/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.listener;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import io.papermc.paper.event.block.BlockLockCheckEvent;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.player.PlayerArmSwingEvent;
import java.util.UUID;
import me.moros.bending.api.ability.ActionType;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.DamageSource;
import me.moros.bending.api.game.Game;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.damage.DamageCause;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.temporal.ActionLimiter;
import me.moros.bending.api.temporal.TempArmor;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.temporal.TempEntity;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.metadata.BlockInteraction;
import me.moros.bending.api.util.metadata.EntityInteraction;
import me.moros.bending.api.util.metadata.Metadata;
import me.moros.bending.common.ability.earth.EarthGlove;
import me.moros.bending.common.ability.earth.MetalCable;
import me.moros.bending.common.ability.earth.passive.Locksmithing;
import me.moros.bending.common.locale.Message;
import me.moros.bending.paper.listener.BukkitListener;
import me.moros.bending.paper.platform.DamageUtil;
import me.moros.bending.paper.platform.PlatformAdapter;
import me.moros.bending.paper.platform.block.LockableImpl;
import me.moros.math.FastMath;
import me.moros.math.Vector3d;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Lockable;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.Vector;
import org.jspecify.annotations.Nullable;

public record UserListener(Game game) implements Listener,
BukkitListener
{
    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onArrowHit(ProjectileHitEvent event) {
        MetalCable cable;
        if (this.disabledWorld((EntityEvent)event)) {
            return;
        }
        if (event.getEntity() instanceof Arrow && event.getEntity().hasMetadata(MetalCable.CABLE_KEY.value()) && (cable = (MetalCable)((MetadataValue)event.getEntity().getMetadata(MetalCable.CABLE_KEY.value()).getFirst()).value()) != null) {
            org.bukkit.block.Block block = event.getHitBlock();
            if (block != null) {
                cable.hitBlock(PlatformAdapter.fromBukkitBlock(block));
            } else {
                Entity entity = event.getHitEntity();
                if (entity instanceof org.bukkit.entity.LivingEntity) {
                    org.bukkit.entity.LivingEntity living = (org.bukkit.entity.LivingEntity)entity;
                    cable.hitEntity(PlatformAdapter.fromBukkitEntity(living));
                } else {
                    event.getEntity().remove();
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityExplodeEvent(EntityExplodeEvent event) {
        this.cancelIfLimited(event, null);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityInteractEvent(EntityInteractEvent event) {
        this.cancelIfLimited(event, ActionType.INTERACT);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onProjectileLaunchEvent(ProjectileLaunchEvent event) {
        this.cancelIfLimited(event, ActionType.SHOOT);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityShootBowEvent(EntityShootBowEvent event) {
        this.cancelIfLimited(event, ActionType.SHOOT);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSlimeSplitEvent(SlimeSplitEvent event) {
        this.cancelIfLimited(event, null);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent event) {
        this.cancelIfLimited(event, null);
    }

    private <E extends EntityEvent> void cancelIfLimited(E event, @Nullable ActionType type) {
        if (this.disabledWorld(event)) {
            return;
        }
        if (ActionLimiter.isLimited(event.getEntity().getUniqueId(), type)) {
            ((Cancellable)event).setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityCombustByBlock(EntityCombustByBlockEvent event) {
        org.bukkit.block.Block block = event.getCombuster();
        if (block == null || this.disabledWorld((EntityEvent)event)) {
            return;
        }
        TempBlock tb = TempBlock.MANAGER.get(PlatformAdapter.fromBukkitBlock(block)).orElse(null);
        if (tb != null) {
            DamageSource source;
            int ticks = FastMath.ceil(event.getDuration() * 20.0f);
            if (ticks > 100) {
                event.setDuration(5.0f);
            }
            if ((source = tb.damageSource()) != null) {
                DamageUtil.cacheDamageSource(event.getEntity().getUniqueId(), source);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamageByBlock(EntityDamageByBlockEvent event) {
        this.onEntityDamageByBlock(event.getEntity(), event.getDamager());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityInsideBlock(EntityInsideBlockEvent event) {
        this.onEntityDamageByBlock(event.getEntity(), event.getBlock());
    }

    private void onEntityDamageByBlock(Entity entity, @Nullable org.bukkit.block.Block block) {
        if (block == null || this.disabledWorld(entity.getWorld())) {
            return;
        }
        TempBlock.MANAGER.get(PlatformAdapter.fromBukkitBlock(block)).map(TempBlock::damageSource).ifPresent(source -> DamageUtil.cacheDamageSource(entity.getUniqueId(), source));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (this.disabledWorld((EntityEvent)event)) {
            return;
        }
        if (event.getDamager() instanceof Arrow && event.getDamager().hasMetadata(MetalCable.CABLE_KEY.value())) {
            event.setCancelled(true);
        } else if (ActionLimiter.isLimited(event.getDamager().getUniqueId(), ActionType.DAMAGE)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onItemMerge(ItemMergeEvent event) {
        if (this.disabledWorld((EntityEvent)event)) {
            return;
        }
        if (event.getEntity().hasMetadata(EarthGlove.GLOVE_KEY.value()) || event.getTarget().hasMetadata(EarthGlove.GLOVE_KEY.value())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (this.disabledWorld((EntityEvent)event)) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlock) {
            FallingBlock fallingBlock = (FallingBlock)entity;
            TempEntity.MANAGER.get(fallingBlock.getEntityId()).ifPresent(temp -> {
                event.setCancelled(true);
                temp.revert();
            });
        } else if (ActionLimiter.isLimited(event.getEntity().getUniqueId(), ActionType.INTERACT_BLOCK)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityDamageLow(EntityDamageEvent event) {
        if (event.getDamage() <= 0.0 || this.disabledWorld((EntityEvent)event)) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof org.bukkit.entity.LivingEntity) {
            double newDamage;
            org.bukkit.entity.LivingEntity bukkitEntity = (org.bukkit.entity.LivingEntity)entity;
            double oldDamage = event.getDamage();
            LivingEntity entity2 = PlatformAdapter.fromBukkitEntity(bukkitEntity);
            DamageCause cause = PlatformAdapter.fromBukkitCause(event.getCause());
            Vector3d origin = null;
            if (event instanceof EntityDamageByEntityEvent) {
                EntityDamageByEntityEvent entityEvent = (EntityDamageByEntityEvent)event;
                origin = PlatformAdapter.fromBukkitEntity(entityEvent.getDamager()).center();
            }
            if ((newDamage = this.game.activationController().onEntityDamage(entity2, cause, oldDamage, origin)) <= 0.0) {
                event.setCancelled(true);
            } else if (Math.abs(oldDamage - newDamage) > 0.001) {
                event.setDamage(newDamage);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        org.bukkit.entity.LivingEntity entity;
        User user;
        if (event.getDamage() <= 0.0 || this.disabledWorld((EntityEvent)event)) {
            return;
        }
        Entity entity2 = event.getEntity();
        if (entity2 instanceof org.bukkit.entity.LivingEntity && (user = (User)Registries.BENDERS.get((entity = (org.bukkit.entity.LivingEntity)entity2).getUniqueId())) != null) {
            this.game.activationController().onUserDamage(user);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onUserGlide(EntityToggleGlideEvent event) {
        Entity entity;
        if (this.disabledWorld((EntityEvent)event)) {
            return;
        }
        if (!event.isGliding() && (entity = event.getEntity()) instanceof org.bukkit.entity.LivingEntity) {
            org.bukkit.entity.LivingEntity entity2 = (org.bukkit.entity.LivingEntity)entity;
            if (ActionLimiter.isLimited(event.getEntity().getUniqueId(), ActionType.MOVE)) {
                event.setCancelled(true);
                return;
            }
            User user = (User)Registries.BENDERS.get(entity2.getUniqueId());
            if (user != null && this.game.activationController().onUserGlide(user)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onAccessLock(BlockLockCheckEvent event) {
        if (event.getPlayer().getGameMode() == GameMode.SPECTATOR || this.disabledWorld((BlockEvent)event)) {
            return;
        }
        User user = (User)Registries.BENDERS.get(event.getPlayer().getUniqueId());
        if (user != null && Locksmithing.canUnlockContainer(user, new LockableImpl((Lockable)event.getBlockState()))) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDeathHigh(EntityDeathEvent event) {
        TempArmor.MANAGER.get(event.getEntity().getUniqueId()).ifPresent(TempArmor::revert);
        NamespacedKey nsk = PlatformAdapter.nsk(Metadata.ARMOR_KEY);
        event.getDrops().removeIf(item -> item.getItemMeta().getPersistentDataContainer().has(nsk));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onUserDeath(EntityDeathEvent event) {
        UUID uuid = event.getEntity().getUniqueId();
        ActionLimiter.MANAGER.get(uuid).ifPresent(ActionLimiter::revert);
        if (this.disabledWorld((EntityEvent)event) || event instanceof PlayerDeathEvent) {
            return;
        }
        Registries.BENDERS.getIfExists(uuid).ifPresent(this.game.activationController()::onUserDeconstruct);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityRemove(EntityRemoveEvent event) {
        if (this.disabledWorld((EntityEvent)event) || event.getEntity().isPersistent()) {
            return;
        }
        UUID uuid = event.getEntity().getUniqueId();
        Registries.BENDERS.getIfExists(uuid).ifPresent(this.game.activationController()::onUserDeconstruct);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        DamageSource cause = DamageUtil.cachedDamageSource(player.getUniqueId());
        if (cause != null) {
            event.deathMessage(Message.ABILITY_DEATH_MESSAGE.build(player.name(), cause.name(), cause.ability()));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onUserMove(EntityMoveEvent event) {
        this.onUserMove((Cancellable)event, event);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onUserMove(PlayerMoveEvent event) {
        this.onUserMove((Cancellable)event, new EntityMoveEvent((org.bukkit.entity.LivingEntity)event.getPlayer(), event.getFrom(), event.getTo()));
    }

    private void onUserMove(Cancellable originalEvent, EntityMoveEvent event) {
        if (this.disabledWorld((EntityEvent)event)) {
            return;
        }
        if (event.hasChangedBlock() && ActionLimiter.isLimited(event.getEntity().getUniqueId(), ActionType.MOVE)) {
            originalEvent.setCancelled(true);
            return;
        }
        User user = (User)Registries.BENDERS.get(event.getEntity().getUniqueId());
        if (user != null) {
            double x = event.getTo().getX() - event.getFrom().getX();
            double z = event.getTo().getZ() - event.getFrom().getZ();
            this.game.activationController().onUserMove(user, Vector3d.of(x, 0.0, z));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerJump(PlayerJumpEvent event) {
        if (this.disabledWorld((PlayerEvent)event)) {
            return;
        }
        if (ActionLimiter.isLimited(event.getPlayer().getUniqueId(), ActionType.MOVE)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onUserSprint(PlayerToggleSprintEvent event) {
        if (this.disabledWorld((PlayerEvent)event)) {
            return;
        }
        if (event.isSprinting() && this.game.activationController().hasSpout(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerInteractLow(PlayerInteractEvent event) {
        if (this.disabledWorld((PlayerEvent)event)) {
            return;
        }
        if (ActionLimiter.isLimited(event.getPlayer().getUniqueId(), ActionType.INTERACT)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerSwing(PlayerArmSwingEvent event) {
        User user;
        if (this.disabledWorld((PlayerEvent)event)) {
            return;
        }
        if (event.getHand() == EquipmentSlot.HAND && event.getAnimationType() == PlayerAnimationType.ARM_SWING && (user = (User)Registries.BENDERS.get(event.getPlayer().getUniqueId())) != null) {
            this.game.activationController().onUserSwing(user);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerInteract(PlayerInteractEvent event) {
        User user;
        if (this.disabledWorld((PlayerEvent)event)) {
            return;
        }
        if ((event.getHand() == EquipmentSlot.HAND || event.getHand() == EquipmentSlot.OFF_HAND && event.getAction() == Action.RIGHT_CLICK_AIR) && (user = (User)Registries.BENDERS.get(event.getPlayer().getUniqueId())) != null && event.getAction().isRightClick()) {
            Block block;
            org.bukkit.block.Block b = event.getClickedBlock();
            Block block2 = block = b == null ? null : PlatformAdapter.fromBukkitBlock(b);
            if (block != null) {
                Location pos = event.getInteractionPoint();
                Vector3d point = pos == null ? null : Vector3d.of(pos.getX(), pos.getY(), pos.getZ());
                user.store().add(BlockInteraction.KEY, new BlockInteraction(block, point));
            }
            this.game.activationController().onUserInteract(user, null, block);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (this.disabledWorld((PlayerEvent)event)) {
            return;
        }
        this.game.activationController().ignoreNextSwing(event.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerInteractAtEntityLow(PlayerInteractAtEntityEvent event) {
        this.onPlayerInteractEntityLow((PlayerInteractEntityEvent)event);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerInteractEntityLow(PlayerInteractEntityEvent event) {
        if (this.disabledWorld((PlayerEvent)event)) {
            return;
        }
        if (TempEntity.MANAGER.isTemp(event.getRightClicked().getEntityId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        Vector pos = event.getClickedPosition();
        this.onPlayerInteractEntity((PlayerInteractEntityEvent)event, Vector3d.of(pos.getX(), pos.getY(), pos.getZ()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        this.onPlayerInteractEntity(event, null);
    }

    private void onPlayerInteractEntity(PlayerInteractEntityEvent event, @Nullable Vector3d point) {
        if (event.getHand() != EquipmentSlot.HAND || this.disabledWorld((PlayerEvent)event)) {
            return;
        }
        User user = (User)Registries.BENDERS.get(event.getPlayer().getUniqueId());
        if (user != null) {
            me.moros.bending.api.platform.entity.Entity target = PlatformAdapter.fromBukkitEntity(event.getRightClicked());
            user.store().add(EntityInteraction.KEY, new EntityInteraction(target, point));
            this.game.activationController().onUserInteract(user, target, null);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        if (this.disabledWorld((PlayerEvent)event)) {
            return;
        }
        User user = (User)Registries.BENDERS.get(event.getPlayer().getUniqueId());
        if (user != null) {
            this.game.activationController().onUserSneak(user, event.isSneaking());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        User user;
        if (this.disabledWorld((PlayerEvent)event)) {
            return;
        }
        if (event.getNewGameMode() == GameMode.SPECTATOR && (user = (User)Registries.BENDERS.get(event.getPlayer().getUniqueId())) != null) {
            this.game.abilityManager(user.worldKey()).destroyUserInstances(user, a -> !a.description().isActivatedBy(Activation.PASSIVE));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerSlotChange(PlayerItemHeldEvent event) {
        if (this.disabledWorld((PlayerEvent)event)) {
            return;
        }
        User user = (User)Registries.BENDERS.get(event.getPlayer().getUniqueId());
        if (user != null) {
            user.board().activeSlot(event.getPreviousSlot() + 1, event.getNewSlot() + 1);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onHopperItemPickup(InventoryPickupItemEvent event) {
        Item item = event.getItem();
        if (item.getItemStack().getType() == Material.STONE && item.hasMetadata(EarthGlove.GLOVE_KEY.value())) {
            event.setCancelled(true);
            event.getItem().remove();
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack item = event.getCurrentItem();
        if (item == null || !(event.getClickedInventory() instanceof PlayerInventory)) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.getPersistentDataContainer().has(PlatformAdapter.nsk(Metadata.ARMOR_KEY))) {
            Player player;
            Inventory inventory = event.getClickedInventory();
            InventoryHolder inventoryHolder = inventory.getHolder();
            if (inventoryHolder instanceof Player && (!TempArmor.MANAGER.isTemp((player = (Player)inventoryHolder).getUniqueId()) || event.getSlotType() != InventoryType.SlotType.ARMOR)) {
                inventory.remove(item);
            }
            event.setCancelled(true);
        }
    }
}

