/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.gui;

import bending.libraries.inventoryframework.gui.GuiItem;
import bending.libraries.inventoryframework.gui.type.ChestGui;
import bending.libraries.inventoryframework.pane.OutlinePane;
import bending.libraries.inventoryframework.pane.Pane;
import bending.libraries.inventoryframework.pane.StaticPane;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import java.util.Map;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.ability.element.ElementHandler;
import me.moros.bending.api.gui.ElementGui;
import me.moros.bending.api.platform.entity.player.Player;
import me.moros.bending.api.platform.item.ItemSnapshot;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.User;
import me.moros.bending.common.gui.AbstractGui;
import me.moros.bending.common.locale.Message;
import me.moros.bending.paper.platform.PlatformAdapter;
import net.kyori.adventure.util.TriState;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public final class ElementMenu
extends AbstractGui<ItemStack, ChestGui> {
    private ElementMenu(ElementHandler handler, Player player) {
        super(handler, player);
    }

    @Override
    protected ChestGui construct(Map<Element, ItemStack> elementMap) {
        ChestGui gui = new ChestGui(3, Message.ELEMENTS_GUI_TITLE.build());
        gui.setOnGlobalClick(event -> event.setCancelled(true));
        OutlinePane background = new OutlinePane(0, 0, 9, 3, Pane.Priority.LOWEST);
        background.addItem(new GuiItem(this.backgroundItem()));
        background.setRepeat(true);
        gui.addPane(background);
        OutlinePane elementsPane = new OutlinePane(1, 1, 7, 1);
        elementsPane.setGap(1);
        User user = (User)Registries.BENDERS.getOrThrow(this.player().uuid());
        for (Element element : Element.VALUES) {
            AbstractGui.DataWrapper data = this.createElementButton(element);
            ItemStack item = PlatformAdapter.toBukkitItem(data.item());
            this.handleItemStackGlow(item, user.hasElement(element));
            elementMap.put(element, item);
            elementsPane.addItem(new GuiItem(item, event -> {
                ClickType click = event.getClick();
                AbstractGui.ActionType action = ElementMenu.mapType(click.isShiftClick(), click.isLeftClick(), click.isRightClick());
                if (action != null) {
                    this.update(this.handleAction(action, data));
                }
            }));
        }
        gui.addPane(elementsPane);
        StaticPane helpPane = new StaticPane(0, 0, 9, 1);
        ItemStack item = PlatformAdapter.toBukkitItem(this.generateHelpItem());
        helpPane.addItem(new GuiItem(item), 4, 0);
        gui.addPane(helpPane);
        return gui;
    }

    private ItemStack backgroundItem() {
        ItemStack item = PlatformAdapter.toBukkitItem((ItemSnapshot)BACKGROUND.get());
        item.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)((TooltipDisplay)TooltipDisplay.tooltipDisplay().hideTooltip(true).build()));
        return item;
    }

    @Override
    public boolean show(Player player) {
        ((ChestGui)this.handle()).show((HumanEntity)PlatformAdapter.toBukkitEntity(player));
        return true;
    }

    private void update(TriState result) {
        switch (result) {
            case TRUE: {
                ((ChestGui)this.handle()).update();
                break;
            }
            case FALSE: {
                this.close();
            }
        }
    }

    private void close() {
        org.bukkit.entity.Player bukkitPlayer = PlatformAdapter.toBukkitEntity(this.player());
        bukkitPlayer.closeInventory();
        bukkitPlayer.updateInventory();
    }

    @Override
    protected void handleItemStackGlow(ItemStack itemStack, boolean glow) {
        itemStack.setData(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, (Object)glow);
    }

    public static ElementGui createMenu(ElementHandler handler, Player player) {
        return new ElementMenu(handler, player);
    }
}

