/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper.adapter;

import io.papermc.paper.ServerBuildInfo;
import me.moros.bending.api.adapter.NativeAdapter;
import me.moros.bending.common.logging.Logger;
import me.moros.bending.paper.adapter.NativeAdapterImpl;

public final class AdapterLoader {
    public static final NativeAdapter DUMMY = new NativeAdapter(){};

    private AdapterLoader() {
    }

    public static NativeAdapter loadAdapter(Logger logger, String version) {
        String mcVersion = ServerBuildInfo.buildInfo().minecraftVersionId();
        if (version.endsWith(".0")) {
            version = version.substring(0, version.length() - 2);
        }
        if (mcVersion.equals(version)) {
            logger.info("Successfully loaded native adapter for version " + mcVersion);
            return new NativeAdapterImpl();
        }
        String s = "\n****************************************************************\n* Unable to find native adapter for version %s.\n* Some features may be unsupported (for example toast notifications) or induce significant overhead.\n* Packet based abilities will utilize real entities instead which can be slower when spawned in large amounts.\n* It is recommended you use a supported version (%s).\n****************************************************************\n".formatted(mcVersion, version);
        logger.warn(s);
        return DUMMY;
    }
}

