/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.paper;

import io.papermc.paper.plugin.loader.PluginClasspathBuilder;
import io.papermc.paper.plugin.loader.PluginLoader;
import io.papermc.paper.plugin.loader.library.ClassPathLibrary;
import io.papermc.paper.plugin.loader.library.impl.MavenLibraryResolver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;

public final class BendingLoader
implements PluginLoader {
    public void classloader(PluginClasspathBuilder classpathBuilder) {
        MavenLibraryResolver resolver = new MavenLibraryResolver();
        resolver.addRepository(new RemoteRepository.Builder("atlas", "default", "https://repo.moros.me/releases").build());
        resolver.addRepository(new RemoteRepository.Builder("paper", "default", "https://repo.papermc.io/repository/maven-public").build());
        for (String dependency : this.readFromResource()) {
            resolver.addDependency(new Dependency((Artifact)new DefaultArtifact(dependency), null));
        }
        classpathBuilder.addLibrary((ClassPathLibrary)resolver);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Iterable<String> readFromResource() {
        try (InputStream is = Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("bending-dependencies"));){
            List<String> list;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                list = reader.lines().toList();
            }
            return list;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

