/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.storage.file.serializer;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.preset.Preset;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.util.TextUtil;
import me.moros.bending.common.storage.file.serializer.AbstractSerializer;
import org.jspecify.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

final class PresetSerializer
extends AbstractSerializer<Preset> {
    static final PresetSerializer INSTANCE = new PresetSerializer();
    private static final TypeToken<Map<Integer, String>> MAP_TOKEN = new TypeToken<Map<Integer, String>>(){};

    private PresetSerializer() {
    }

    public Preset deserialize(Type type, ConfigurationNode source) throws SerializationException {
        Preset result;
        String name = Optional.ofNullable(source.key()).map(Object::toString).orElse("");
        if (!TextUtil.sanitizeInput(name).equals(name)) {
            throw new SerializationException(source, String.class, "Invalid preset name: " + name);
        }
        Map input = (Map)source.get(MAP_TOKEN, Map.of());
        AbilityDescription[] output = new AbilityDescription[9];
        if (!input.isEmpty()) {
            for (int i = 0; i < output.length; ++i) {
                String current = (String)input.get(i + 1);
                if (current == null) continue;
                output[i] = Registries.ABILITIES.fromString(current);
            }
        }
        if ((result = Preset.create(name, output)).isEmpty()) {
            throw new SerializationException("Empty preset " + name);
        }
        return result;
    }

    public void serialize(Type type, @Nullable Preset preset, ConfigurationNode target) throws SerializationException {
        if (preset == null || preset.isEmpty()) {
            target.raw(null);
            return;
        }
        LinkedHashMap output = new LinkedHashMap(12);
        preset.forEach((desc, idx) -> output.put(idx + 1, desc.key().asString()));
        target.set(MAP_TOKEN, output);
    }
}

