/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.storage.file.serializer;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.ability.preset.Preset;
import me.moros.bending.api.user.profile.BenderProfile;
import me.moros.bending.api.util.collect.ElementSet;
import me.moros.bending.common.storage.file.IOFunction;
import me.moros.bending.common.storage.file.serializer.AbstractSerializer;
import org.jspecify.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

final class BenderProfileSerializer
extends AbstractSerializer<BenderProfile> {
    static final BenderProfileSerializer INSTANCE = new BenderProfileSerializer();
    private static final String UUID = "uuid";
    private static final String BOARD = "board";
    private static final String SLOTS = "slots";
    private static final String ELEMENTS = "elements";
    private static final String PRESETS = "presets";
    private static final TypeToken<Set<Element>> ELEMENT_SET_TOKEN = new TypeToken<Set<Element>>(){};
    private static final TypeToken<Map<String, Preset>> PRESET_MAP_TOKEN = new TypeToken<Map<String, Preset>>(){};

    private BenderProfileSerializer() {
    }

    public BenderProfile deserialize(Type type, ConfigurationNode source) throws SerializationException {
        ConfigurationNode uuidNode = BenderProfileSerializer.nonVirtualNode(source, UUID);
        UUID uuid = (UUID)uuidNode.get(UUID.class);
        if (uuid == null) {
            throw new SerializationException(uuidNode, UUID.class, "Invalid uuid.");
        }
        boolean board = this.getSafe(BenderProfileSerializer.nonVirtualNodeOrNull(source, BOARD), n -> n.getBoolean(true)).orElse(true);
        Set elements = this.getSafe(BenderProfileSerializer.nonVirtualNodeOrNull(source, ELEMENTS), n -> (Set)n.get(ELEMENT_SET_TOKEN)).orElseGet(ElementSet::of);
        Preset slots = this.getSafe(BenderProfileSerializer.nonVirtualNodeOrNull(source, SLOTS), n -> (Preset)n.get(Preset.class)).orElseGet(Preset::empty);
        Map presetMap = this.getSafe(BenderProfileSerializer.nonVirtualNodeOrNull(source, PRESETS), n -> (Map)n.get(PRESET_MAP_TOKEN)).orElseGet(Map::of);
        return BenderProfile.of(uuid, board, elements, slots, presetMap.values());
    }

    public void serialize(Type type, @Nullable BenderProfile profile, ConfigurationNode target) throws SerializationException {
        if (profile == null) {
            target.raw(null);
            return;
        }
        target.node(new Object[]{UUID}).set((Object)profile.uuid());
        target.node(new Object[]{BOARD}).set((Object)profile.board());
        target.node(new Object[]{ELEMENTS}).set(ELEMENT_SET_TOKEN, (Object)profile.elements());
        target.node(new Object[]{SLOTS}).set(Preset.class, (Object)profile.slots());
        target.node(new Object[]{PRESETS}).set(PRESET_MAP_TOKEN, profile.presets());
    }

    private <T> Optional<T> getSafe(@Nullable ConfigurationNode node, IOFunction<ConfigurationNode, T> mapper) {
        if (node != null) {
            try {
                return Optional.ofNullable(mapper.apply(node));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Optional.empty();
    }
}

