/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.placeholder;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.common.locale.Message;
import me.moros.bending.common.placeholder.DynamicPlaceholder;
import me.moros.bending.common.placeholder.Placeholder;
import me.moros.bending.common.placeholder.StaticPlaceholder;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyedValue;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;

interface Placeholders {
    public static final KeyedValue<StaticPlaceholder> ELEMENTS = Placeholders.create("elements", Placeholder.of(Placeholders::userElements));
    public static final KeyedValue<StaticPlaceholder> ELEMENT = Placeholders.create("element", Placeholder.of(Placeholders::findElement));
    public static final KeyedValue<StaticPlaceholder> DISPLAY_NAME = Placeholders.create("display_name", Placeholder.of(Placeholders::displayName));
    public static final KeyedValue<StaticPlaceholder> SELECTED_ABILITY = Placeholders.create("selected_ability", Placeholder.of(Placeholders::selectedAbility));
    public static final KeyedValue<DynamicPlaceholder> SLOT = Placeholders.create("slot", Placeholder.of(Placeholders::slot));
    public static final KeyedValue<DynamicPlaceholder> ABILITY_INFO = Placeholders.create("ability_info", Placeholder.of(Placeholders::abilityInfo));

    private static <T extends Placeholder> KeyedValue<T> create(String id, T placeholder) {
        return KeyedValue.keyedValue((Key)KeyUtil.simple(id), placeholder);
    }

    private static Component userElements(User user) {
        JoinConfiguration sep = JoinConfiguration.commas((boolean)true);
        List<Component> elements = user.elements().stream().map(Element::displayName).toList();
        return Component.join((JoinConfiguration)sep, elements).colorIfAbsent(ColorPalette.TEXT_COLOR);
    }

    private static Component findElement(User user) {
        TextComponent empty = Component.text((String)"NonBender");
        TextComponent avatar = Component.text((String)"Avatar");
        return Placeholders.withElementColor(user, Element::displayName, (Component)empty, (Component)avatar);
    }

    private static Component displayName(User user) {
        Component name = (Component)user.pointers().getOrDefaultFrom(Identity.DISPLAY_NAME, user::name);
        return Placeholders.withElementColor(user, e -> name.colorIfAbsent(e.color()), name, name);
    }

    private static Component withElementColor(User user, Function<Element, Component> function, Component nonBender, Component avatar) {
        Set userElements = user.elements();
        if (userElements.isEmpty()) {
            return nonBender;
        }
        if (userElements.size() > 1) {
            return avatar.colorIfAbsent(ColorPalette.AVATAR);
        }
        return function.apply((Element)((Object)userElements.iterator().next()));
    }

    private static Component selectedAbility(User user) {
        AbilityDescription desc = user.selectedAbility();
        return desc == null ? Component.empty() : desc.displayName();
    }

    private static Component slot(User user, String slot) {
        AbilityDescription desc = user.boundAbility(Integer.parseInt(slot));
        return desc == null ? Component.empty() : desc.displayName();
    }

    private static Component abilityInfo(User user, String abilityName) {
        Component instructions;
        AbilityDescription desc = Registries.ABILITIES.fromString(abilityName);
        if (desc == null) {
            return Component.empty();
        }
        if (desc instanceof AbilityDescription.Sequence) {
            AbilityDescription.Sequence sequence = (AbilityDescription.Sequence)desc;
            instructions = sequence.instructions();
        } else {
            instructions = Message.ABILITY_INSTRUCTIONS.build(desc);
        }
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])new ComponentLike[]{Message.ABILITY_DESCRIPTION.build(desc), instructions});
    }
}

