/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.placeholder;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.common.placeholder.DynamicPlaceholder;
import me.moros.bending.common.placeholder.Placeholder;
import me.moros.bending.common.placeholder.StaticPlaceholder;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyedValue;
import net.kyori.adventure.text.Component;

public final class PlaceholderProvider
implements Iterable<KeyedValue<? extends Placeholder>> {
    private final Set<KeyedValue<? extends Placeholder>> placeholders;

    private PlaceholderProvider(Builder builder) {
        this.placeholders = Set.copyOf(builder.placeholders);
    }

    public Component onPlaceholderRequest(User user, String placeholder) {
        for (KeyedValue<? extends Placeholder> keyed : this.placeholders) {
            String id = keyed.key().value();
            Placeholder p = (Placeholder)keyed.value();
            int dynamicLength = id.length() + 1;
            if (p instanceof DynamicPlaceholder) {
                DynamicPlaceholder dp = (DynamicPlaceholder)p;
                if (placeholder.startsWith(id + "_") && placeholder.length() > dynamicLength) {
                    return dp.handle(user, placeholder.substring(dynamicLength));
                }
            }
            if (!(p instanceof StaticPlaceholder)) continue;
            StaticPlaceholder sp = (StaticPlaceholder)p;
            if (!placeholder.equals(id)) continue;
            return sp.handle(user);
        }
        return Component.empty();
    }

    @Override
    public Iterator<KeyedValue<? extends Placeholder>> iterator() {
        return this.placeholders.iterator();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder defaultBuilder() {
        return PlaceholderProvider.builder().add((KeyedValue<? extends Placeholder>)Placeholder.ELEMENTS).add((KeyedValue<? extends Placeholder>)Placeholder.ELEMENT).add((KeyedValue<? extends Placeholder>)Placeholder.DISPLAY_NAME).add((KeyedValue<? extends Placeholder>)Placeholder.SELECTED_ABILITY).add((KeyedValue<? extends Placeholder>)Placeholder.SLOT).add((KeyedValue<? extends Placeholder>)Placeholder.ABILITY_INFO);
    }

    public static final class Builder {
        private final Set<KeyedValue<? extends Placeholder>> placeholders = new LinkedHashSet<KeyedValue<? extends Placeholder>>();

        private Builder() {
        }

        public Builder add(KeyedValue<? extends Placeholder> keyed) {
            this.placeholders.add(keyed);
            return this;
        }

        public Builder addStatic(String id, Function<User, Component> function) {
            this.placeholders.add((KeyedValue<? extends Placeholder>)KeyedValue.keyedValue((Key)KeyUtil.simple(id), (Object)Placeholder.of(function)));
            return this;
        }

        public Builder addDynamic(String id, BiFunction<User, String, Component> function) {
            this.placeholders.add((KeyedValue<? extends Placeholder>)KeyedValue.keyedValue((Key)KeyUtil.simple(id), (Object)Placeholder.of(function)));
            return this;
        }

        public PlaceholderProvider build() {
            return new PlaceholderProvider(this);
        }
    }
}

