/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.loader;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;

final class AddonClassLoader
extends URLClassLoader {
    AddonClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    AddonClassLoader loadJars(Path dir) {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            try (Stream<Path> stream = Files.list(dir);){
                stream.filter(f -> f.getFileName().toString().endsWith(".jar")).forEach(this::tryAddUrl);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    private void tryAddUrl(Path path) {
        try {
            this.addURL(path.toUri().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

