/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.hook;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.IntStream;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.addon.Addon;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.common.hook.PresetLimits;
import net.kyori.adventure.key.Key;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextConsumer;
import net.luckperms.api.context.ContextManager;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.model.user.UserManager;
import org.jspecify.annotations.Nullable;

public final class LuckPermsHook<T> {
    private final Function<T, UUID> uuidExtractor;
    private final UserManager userManager;

    private LuckPermsHook(Function<T, UUID> uuidExtractor, LuckPerms luckPerms) {
        this.uuidExtractor = uuidExtractor;
        this.userManager = luckPerms.getUserManager();
        this.setupContexts(luckPerms.getContextManager());
    }

    private void setupContexts(ContextManager manager) {
        this.builder("element").suggestions(Element.NAMES).build(u -> u.elements().stream().map(Element::toString).toList()).register(manager);
        this.builder("avatar").suggestions(List.of("true", "false")).build(this.fromSingleValue(u -> String.valueOf(u.elements().size() >= Element.VALUES.size()))).register(manager);
        this.builder("element-count").suggestions(IntStream.rangeClosed(0, Element.VALUES.size()).mapToObj(String::valueOf).toList()).build(this.fromSingleValue(u -> String.valueOf(u.elements().size()))).register(manager);
    }

    private Function<User, Iterable<String>> fromSingleValue(Function<User, String> valueMapper) {
        return u -> List.of((String)valueMapper.apply((User)u));
    }

    private @Nullable User adapt(T user) {
        return (User)Registries.BENDERS.get(this.uuidExtractor.apply(user));
    }

    private int limits(User user) {
        net.luckperms.api.model.user.User lpUser = this.userManager.getUser(user.uuid());
        return lpUser != null ? lpUser.getCachedData().getMetaData(lpUser.getQueryOptions()).getMetaValue("bending-max-presets", Integer::parseInt).orElseGet(BendingProperties.instance()::maxPresets) : 0;
    }

    public Addon presetLimits() {
        return new PresetLimits(this::limits);
    }

    private Builder<T> builder(String key) {
        return new Builder<Object>(key, this::adapt);
    }

    private static ContextSet createContextSet(String key, Iterable<String> values) {
        ImmutableContextSet.Builder builder = ImmutableContextSet.builder();
        values.forEach(value -> builder.add(key, value.toLowerCase(Locale.ROOT)));
        return builder.build();
    }

    public static <T> LuckPermsHook<T> register(Function<T, UUID> uuidExtractor) throws IllegalStateException {
        return new LuckPermsHook<T>(uuidExtractor, LuckPermsProvider.get());
    }

    private static final class Builder<T> {
        private final Key key;
        private final Function<T, User> userAdapter;
        private ContextSet suggestions;

        private Builder(String key, Function<T, User> userAdapter) {
            this.key = KeyUtil.simple(key.toLowerCase(Locale.ROOT));
            this.userAdapter = userAdapter;
        }

        private Builder<T> suggestions(Collection<String> suggestions) {
            this.suggestions = LuckPermsHook.createContextSet(this.key.asString(), suggestions);
            return this;
        }

        private BendingContextCalculator<T> build(Function<User, Iterable<String>> mapper) {
            return new MappingContextCalculator<T>(this.key.asString(), this.suggestions, this.userAdapter, mapper);
        }
    }

    private static interface BendingContextCalculator<T>
    extends ContextCalculator<T> {
        public String key();

        default public void calculate(T target, ContextConsumer consumer) {
            User user = this.userAdapter().apply(target);
            if (user != null) {
                consumer.accept(LuckPermsHook.createContextSet(this.key(), this.mapper().apply(user)));
            }
        }

        public Function<T, @Nullable User> userAdapter();

        public Function<User, Iterable<String>> mapper();

        default public void register(ContextManager contextManager) {
            contextManager.registerCalculator((ContextCalculator)this);
        }
    }

    private record MappingContextCalculator<T>(String key, ContextSet estimatePotentialContexts, Function<T, User> userAdapter, Function<User, Iterable<String>> mapper) implements BendingContextCalculator<T>
    {
    }
}

