/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.game;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.SequenceStep;
import me.moros.bending.api.game.ActivationController;
import me.moros.bending.api.game.SequenceManager;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.User;

public final class SequenceManagerImpl
implements SequenceManager {
    private final ActivationController controller;
    private final LoadingCache<UUID, Deque<SequenceStep>> cache;

    SequenceManagerImpl(ActivationController controller) {
        this.controller = controller;
        this.cache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build(u -> new ArrayDeque(16));
        this.tryInitRegistry();
    }

    private void tryInitRegistry() {
        if (Registries.SEQUENCES.isLocked()) {
            return;
        }
        for (AbilityDescription desc : Registries.ABILITIES) {
            AbilityDescription.Sequence sequence;
            if (!(desc instanceof AbilityDescription.Sequence) || !this.isValid(sequence = (AbilityDescription.Sequence)desc)) continue;
            Registries.SEQUENCES.register(sequence);
        }
    }

    private boolean isValid(AbilityDescription.Sequence sequence) {
        return sequence.steps().stream().map(SequenceStep::ability).allMatch(Registries.ABILITIES::containsValue);
    }

    @Override
    public void registerStep(User user, Activation action) {
        AbilityDescription desc = user.selectedAbility();
        if (desc == null) {
            return;
        }
        Deque buffer = (Deque)this.cache.get((Object)user.uuid());
        if (buffer.size() >= 16) {
            buffer.removeFirst();
        }
        buffer.addLast(SequenceStep.of(desc, action));
        ArrayList<SequenceStep> bufferSteps = new ArrayList<SequenceStep>(buffer);
        for (AbilityDescription.Sequence sequence : Registries.SEQUENCES) {
            if (!sequence.matches(bufferSteps) || this.controller.activateAbility(user, Activation.SEQUENCE, sequence) == null) continue;
            buffer.clear();
            return;
        }
    }
}

