/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.game;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.moros.bending.api.config.ConfigProcessor;
import me.moros.bending.api.event.EventBus;
import me.moros.bending.api.game.AbilityManager;
import me.moros.bending.api.game.ActivationController;
import me.moros.bending.api.game.FlightManager;
import me.moros.bending.api.game.Game;
import me.moros.bending.api.game.WorldManager;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.registry.Registry;
import me.moros.bending.api.storage.BendingStorage;
import me.moros.bending.api.temporal.ActionLimiter;
import me.moros.bending.api.temporal.Cooldown;
import me.moros.bending.api.temporal.TempArmor;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.temporal.TempDisplayEntity;
import me.moros.bending.api.temporal.TempEntity;
import me.moros.bending.api.temporal.TempLight;
import me.moros.bending.api.temporal.TemporalManager;
import me.moros.bending.api.user.User;
import me.moros.bending.api.user.profile.BenderProfile;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.Tasker;
import me.moros.bending.api.util.TextUtil;
import me.moros.bending.common.Bending;
import me.moros.bending.common.ability.AbilityInitializer;
import me.moros.bending.common.event.EventBusImpl;
import me.moros.bending.common.game.ActivationControllerImpl;
import me.moros.bending.common.game.FlightManagerImpl;
import me.moros.bending.common.game.WorldManagerImpl;
import me.moros.bending.common.storage.StorageFactory;

public final class GameImpl
implements Game {
    private final Bending plugin;
    private final ConfigProcessor configProcessor;
    private final EventBus eventBus;
    private final FlightManager flightManager;
    private final WorldManager worldManager;
    private final ActivationController activationController;
    private final Collection<TemporalManager<?, ?>> temporal;
    private final BendingStorage storage;

    public GameImpl(Bending plugin) {
        this.plugin = plugin;
        this.configProcessor = plugin.configManager().processor();
        this.eventBus = new EventBusImpl(plugin.logger());
        this.flightManager = new FlightManagerImpl();
        this.worldManager = new WorldManagerImpl(plugin.logger());
        this.activationController = new ActivationControllerImpl();
        this.temporal = List.of(Cooldown.MANAGER, TempLight.MANAGER, TempEntity.MANAGER, TempDisplayEntity.MANAGER, ActionLimiter.MANAGER, TempArmor.MANAGER, TempBlock.MANAGER);
        this.lockRegistries();
        this.storage = new StorageFactory(plugin).createInstance();
        AbilityInitializer.initConfigs();
        plugin.configManager().save();
        Tasker.sync().repeat(this::update, 1);
        Tasker.sync().repeat(BendingEffect::cleanup, 5);
        this.printInfo();
    }

    private void lockRegistries() {
        Map registries = Registries.keys().map(Registries::getOrThrow).filter(r -> !r.isLocked()).collect(Collectors.toMap(Registry::key, Function.identity()));
        this.eventBus.postRegistryLockEvent(registries.keySet());
        registries.values().forEach(Registry::lock);
    }

    private void printInfo() {
        int abilityAmount = Registries.ABILITIES.size();
        int sequenceAmount = Registries.SEQUENCES.size();
        int collisionAmount = Registries.COLLISIONS.size();
        this.plugin.logger().info("Found %d registered abilities (%d Sequences)".formatted(abilityAmount, sequenceAmount));
        this.plugin.logger().info("Found %d registered collisions".formatted(collisionAmount));
        this.plugin.logger().info("Registered protection plugins: " + TextUtil.collect(Registries.PROTECTIONS));
    }

    private void update() {
        this.activationController.clearCache();
        try {
            this.temporal.forEach(TemporalManager::tick);
            this.worldManager.update();
            this.flightManager.update();
        }
        catch (Throwable t) {
            this.plugin.logger().error(t.getMessage(), t);
        }
    }

    @Override
    public void reload() {
        this.cleanup();
        Registries.BENDERS.forEach(u -> this.worldManager.instance(u.worldKey()).createPassives((User)u));
    }

    @Override
    public void cleanup() {
        this.worldManager.forEach(AbilityManager::destroyAllInstances);
        this.flightManager.removeAll();
        this.temporal.forEach(TemporalManager::removeAll);
        List<BenderProfile> profiles = Registries.BENDERS.players().map(User::toProfile).toList();
        this.storage.saveProfilesAsync(profiles);
    }

    @Override
    public EventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public BendingStorage storage() {
        return this.storage;
    }

    @Override
    public FlightManager flightManager() {
        return this.flightManager;
    }

    @Override
    public WorldManager worldManager() {
        return this.worldManager;
    }

    @Override
    public ActivationController activationController() {
        return this.activationController;
    }

    @Override
    public ConfigProcessor configProcessor() {
        return this.configProcessor;
    }
}

