/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.game;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.game.ActivationController;
import me.moros.bending.api.game.SequenceManager;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.damage.DamageCause;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.entity.player.Player;
import me.moros.bending.api.protection.ProtectionCache;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.temporal.ActionLimiter;
import me.moros.bending.api.temporal.TempArmor;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.common.ability.SpoutAbility;
import me.moros.bending.common.ability.air.AirBlast;
import me.moros.bending.common.ability.air.AirScooter;
import me.moros.bending.common.ability.air.Tornado;
import me.moros.bending.common.ability.air.passive.GracefulDescent;
import me.moros.bending.common.ability.air.sequence.AirWheel;
import me.moros.bending.common.ability.earth.EarthArmor;
import me.moros.bending.common.ability.earth.EarthLine;
import me.moros.bending.common.ability.earth.EarthSmash;
import me.moros.bending.common.ability.earth.EarthSurf;
import me.moros.bending.common.ability.earth.passive.DensityShift;
import me.moros.bending.common.ability.earth.passive.FerroControl;
import me.moros.bending.common.ability.earth.sequence.EarthPillars;
import me.moros.bending.common.ability.fire.FireJet;
import me.moros.bending.common.ability.fire.FireShield;
import me.moros.bending.common.ability.fire.HeatControl;
import me.moros.bending.common.ability.water.BloodBending;
import me.moros.bending.common.ability.water.HealingWaters;
import me.moros.bending.common.ability.water.WaterWave;
import me.moros.bending.common.ability.water.passive.HydroSink;
import me.moros.bending.common.ability.water.sequence.Iceberg;
import me.moros.bending.common.ability.water.sequence.WaterGimbal;
import me.moros.bending.common.game.SequenceManagerImpl;
import me.moros.math.Vector3d;
import org.jspecify.annotations.Nullable;

public final class ActivationControllerImpl
implements ActivationController {
    private final ControllerCache cache = new ControllerCache(new HashMap<UUID, SpoutAbility>(), new HashSet<UUID>());
    private final SequenceManager sequenceManager = new SequenceManagerImpl(this);

    ActivationControllerImpl() {
    }

    @Override
    public @Nullable Ability activateAbility(User user, Activation method) {
        AbilityDescription desc = user.selectedAbility();
        return desc == null ? null : this.activateAbility(user, method, desc);
    }

    @Override
    public @Nullable Ability activateAbility(User user, Activation method, AbilityDescription desc) {
        Ability ability;
        if (desc.isActivatedBy(method) && user.canBend(desc) && user.canBuild() && (ability = desc.createAbility()).activate(user, method)) {
            user.game().abilityManager(user.worldKey()).addAbility(ability);
            user.game().eventBus().postAbilityActivationEvent(user, desc, method);
            return ability;
        }
        return null;
    }

    @Override
    public void onUserDeconstruct(User user) {
        UUID uuid = user.uuid();
        ActionLimiter.MANAGER.get(uuid).ifPresent(ActionLimiter::revert);
        TempArmor.MANAGER.get(uuid).ifPresent(TempArmor::revert);
        user.game().abilityManager(user.worldKey()).destroyUserInstances(user);
        if (user instanceof Player) {
            user.game().storage().saveProfileAsync(user.toProfile());
        }
        user.board().disableScoreboard();
        user.game().flightManager().remove(uuid);
        Registries.BENDERS.invalidateKey(uuid);
        ProtectionCache.INSTANCE.invalidate(uuid);
    }

    @Override
    public void onUserSwing(User user) {
        if (!this.cache.addInteraction(user.uuid())) {
            return;
        }
        if (user.game().abilityManager(user.worldKey()).destroyUserInstances(user, List.of(AirScooter.class, AirWheel.class, EarthSurf.class))) {
            return;
        }
        WaterWave.freeze(user);
        Iceberg.launch(user);
        WaterGimbal.launch(user);
        this.sequenceManager.registerStep(user, Activation.ATTACK);
        this.activateAbility(user, Activation.ATTACK);
    }

    @Override
    public boolean onUserGlide(User user) {
        return user.game().abilityManager(user.worldKey()).hasAbility(user, FireJet.class);
    }

    @Override
    public void onUserSneak(User user, boolean sneaking) {
        Activation action;
        Activation activation = action = sneaking ? Activation.SNEAK : Activation.SNEAK_RELEASE;
        if (sneaking && user.game().abilityManager(user.worldKey()).destroyUserInstances(user, WaterWave.class)) {
            return;
        }
        this.sequenceManager.registerStep(user, action);
        this.activateAbility(user, action);
    }

    @Override
    public void onUserMove(User user, Vector3d velocity) {
        SpoutAbility spout;
        if ((user.hasElement(Element.AIR) || user.hasElement(Element.WATER)) && (spout = this.cache.getSpout(user)) != null) {
            spout.handleMovement(velocity);
        }
    }

    @Override
    public void onUserDamage(User user) {
        user.game().abilityManager(user.worldKey()).destroyUserInstances(user, List.of(AirScooter.class, EarthSurf.class));
    }

    @Override
    public double onEntityDamage(LivingEntity entity, DamageCause cause, double damage, @Nullable Vector3d origin) {
        User user = (User)Registries.BENDERS.get(entity.uuid());
        if (user != null) {
            if (cause == DamageCause.FIRE && !this.onBurn(user)) {
                BendingEffect.FIRE_TICK.reset(entity);
                return 0.0;
            }
            if (cause == DamageCause.FALL && !this.onFall(user)) {
                return 0.0;
            }
            if (cause == DamageCause.KINETIC && this.onUserGlide(user)) {
                return 0.0;
            }
            if (cause == DamageCause.EXPLOSION && origin != null) {
                return FireShield.shieldFromExplosion(user, origin, damage);
            }
        }
        if (cause == DamageCause.SUFFOCATION && this.noSuffocate(entity)) {
            return 0.0;
        }
        return damage;
    }

    @Override
    public boolean onBurn(User user) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, FireJet.class)) {
            return false;
        }
        if (EarthArmor.hasArmor(user)) {
            return false;
        }
        return HeatControl.canBurn(user);
    }

    @Override
    public boolean onFall(User user) {
        EarthPillars.onFall(user);
        this.activateAbility(user, Activation.FALL);
        if (user.hasElement(Element.AIR) && GracefulDescent.isGraceful(user)) {
            return false;
        }
        if (user.hasElement(Element.WATER) && HydroSink.canHydroSink(user)) {
            return false;
        }
        if (user.hasElement(Element.EARTH) && DensityShift.isSoftened(user)) {
            return false;
        }
        return !user.game().flightManager().hasFlight(user);
    }

    private boolean noSuffocate(LivingEntity e) {
        double f = 0.4 * e.width();
        AABB box = AABB.of(Vector3d.of(-f, -0.05, -f), Vector3d.of(f, 0.05, f)).at(e.eyeLocation());
        return e.world().nearbyBlocks(box, this::canSuffocate, 1).isEmpty();
    }

    private boolean canSuffocate(Block block) {
        return block.type().isCollidable() && !TempBlock.MANAGER.isTemp(block);
    }

    @Override
    public void onUserInteract(User user, @Nullable Entity entity, @Nullable Block block) {
        if (!user.canBend() || !this.cache.addInteraction(user.uuid())) {
            return;
        }
        Activation method = Activation.INTERACT;
        if (block != null) {
            method = Activation.INTERACT_BLOCK;
            FerroControl.act(user, block);
            EarthSmash.tryDestroy(user, block);
        } else if (entity != null) {
            method = Activation.INTERACT_ENTITY;
        }
        Tornado.switchMode(user);
        AirBlast.switchMode(user);
        EarthLine.switchMode(user);
        BloodBending.switchMode(user);
        HealingWaters.switchMode(user);
        HeatControl.toggleMode(user);
        this.sequenceManager.registerStep(user, method);
        this.activateAbility(user, method);
    }

    @Override
    public void ignoreNextSwing(UUID uuid) {
        this.cache.addInteraction(uuid);
    }

    @Override
    public boolean hasSpout(UUID uuid) {
        return this.cache.spoutCache.containsKey(uuid);
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    private record ControllerCache(Map<UUID, SpoutAbility> spoutCache, Set<UUID> interactionCache) {
        private @Nullable SpoutAbility getSpout(User user) {
            return this.spoutCache.computeIfAbsent(user.uuid(), u -> user.game().abilityManager(user.worldKey()).firstInstance(user, SpoutAbility.class).orElse(null));
        }

        private void clear() {
            this.spoutCache.clear();
            this.interactionCache.clear();
        }

        private boolean addInteraction(UUID uuid) {
            return this.interactionCache.add(uuid);
        }
    }
}

