/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.game;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.MultiUpdatable;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.game.AbilityManager;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.User;
import me.moros.bending.common.logging.Logger;
import net.kyori.adventure.key.Key;

public class AbilityManagerImpl
implements AbilityManager {
    private final Logger logger;
    private final Key world;
    private final Map<UUID, Queue<Ability>> globalInstances;
    private final Collection<Updatable> pending;
    private final MultiUpdatable<Updatable> generics;
    private int size;

    AbilityManagerImpl(Logger logger, Key world) {
        this.logger = logger;
        this.world = world;
        this.globalInstances = new ConcurrentHashMap<UUID, Queue<Ability>>(32);
        this.pending = new ArrayList<Updatable>();
        this.generics = MultiUpdatable.empty();
    }

    private void addAbilityInternal(UUID uuid, Ability instance) {
        this.globalInstances.computeIfAbsent(uuid, k -> new ConcurrentLinkedQueue()).add(instance);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Ability> iterator() {
        return this.instances().iterator();
    }

    @Override
    public void addUpdatable(Updatable instance) {
        if (instance instanceof Ability) {
            Ability ability = (Ability)instance;
            this.addAbility(ability);
        } else {
            this.pending.add(instance);
        }
    }

    @Override
    public void addAbility(Ability instance) {
        User user = instance.user();
        if (this.world.equals((Object)user.worldKey())) {
            this.addAbilityInternal(user.uuid(), instance);
        }
    }

    @Override
    public void createPassives(User user) {
        if (!this.world.equals((Object)user.worldKey())) {
            return;
        }
        Predicate<AbilityDescription> isPassive = desc -> desc.isActivatedBy(Activation.PASSIVE);
        List<AbilityDescription> allPassives = Registries.ABILITIES.stream().filter(isPassive).toList();
        this.destroyUserInstances(user, (Ability a) -> isPassive.test(a.description()));
        for (AbilityDescription passive : allPassives) {
            Ability ability;
            if (!user.hasElements(passive.elements()) || !user.hasPermission(passive) || !(ability = passive.createAbility()).activate(user, Activation.PASSIVE)) continue;
            this.addAbility(ability);
        }
    }

    @Override
    public void changeOwner(Ability ability, User user) {
        if (ability.user().equals(user) || !ability.user().worldKey().equals((Object)user.worldKey()) || !this.world.equals((Object)user.worldKey())) {
            return;
        }
        Collection holder = this.globalInstances.get(ability.user().uuid());
        if (holder != null && holder.remove(ability)) {
            ability.onUserChange(user);
            ability.loadConfig();
            this.addAbilityInternal(user.uuid(), ability);
        }
    }

    @Override
    public Stream<Ability> userInstances(User user) {
        Collection holder = this.globalInstances.get(user.uuid());
        return holder != null ? holder.stream() : Stream.of(new Ability[0]);
    }

    @Override
    public Stream<Ability> instances() {
        return this.globalInstances.values().stream().flatMap(Collection::stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Updatable.UpdateResult update() {
        this.pending.forEach(this.generics::add);
        this.pending.clear();
        this.generics.update();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Iterator<Queue<Ability>> iterator = this.globalInstances.values().iterator();
        this.size = 0;
        while (iterator.hasNext()) {
            Collection abilities = iterator.next();
            Iterator innerIterator = abilities.iterator();
            while (innerIterator.hasNext()) {
                Ability ability = (Ability)innerIterator.next();
                Updatable.UpdateResult result = Updatable.UpdateResult.REMOVE;
                try {
                    result = ability.update();
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
                finally {
                    if (result == Updatable.UpdateResult.REMOVE) {
                        innerIterator.remove();
                        ability.onDestroy();
                        continue;
                    }
                    ++this.size;
                }
            }
            if (!abilities.isEmpty()) continue;
            iterator.remove();
        }
        for (Exception e : exceptions) {
            this.logger.error(e.getMessage(), e);
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    @Override
    public boolean destroyUserInstances(User user, Predicate<Ability> predicate) {
        boolean destroyed = false;
        Collection holder = this.globalInstances.get(user.uuid());
        if (holder != null) {
            Iterator iterator = holder.iterator();
            while (iterator.hasNext()) {
                Ability ability = (Ability)iterator.next();
                if (!predicate.test(ability)) continue;
                iterator.remove();
                ability.onDestroy();
                destroyed = true;
            }
        }
        return destroyed;
    }

    @Override
    public void destroyUserInstances(User user) {
        Collection holder = this.globalInstances.remove(user.uuid());
        if (holder != null) {
            holder.forEach(Ability::onDestroy);
            holder.clear();
        }
    }

    @Override
    public void destroyInstance(Ability ability) {
        Collection holder = this.globalInstances.get(ability.user().uuid());
        if (holder != null && holder.remove(ability)) {
            ability.onDestroy();
        }
    }

    @Override
    public void destroyAllInstances() {
        this.pending.clear();
        this.generics.clear();
        for (Collection collection : this.globalInstances.values()) {
            collection.forEach(Ability::onDestroy);
            collection.clear();
        }
        this.globalInstances.clear();
    }

    @Override
    public Key worldKey() {
        return this.world;
    }
}

