/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.event;

import bending.libraries.eventbus.EventConfig;
import bending.libraries.eventbus.bus.EventBus;
import bending.libraries.eventbus.bus.SimpleEventBus;
import bending.libraries.eventbus.registry.EventRegistry;
import bending.libraries.eventbus.registry.SimpleEventRegistry;
import java.util.Collection;
import java.util.function.Consumer;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.ability.preset.Preset;
import me.moros.bending.api.event.ActionLimitEvent;
import me.moros.bending.api.event.BendingDamageEvent;
import me.moros.bending.api.event.BendingEvent;
import me.moros.bending.api.event.BendingExplosionEvent;
import me.moros.bending.api.event.Cancellable;
import me.moros.bending.api.event.ElementChangeEvent;
import me.moros.bending.api.event.EventBus;
import me.moros.bending.api.event.TickEffectEvent;
import me.moros.bending.api.event.VelocityEvent;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.data.DataKey;
import me.moros.bending.common.event.AbilityActivationEventImpl;
import me.moros.bending.common.event.ActionLimitEventImpl;
import me.moros.bending.common.event.BendingDamageEventImpl;
import me.moros.bending.common.event.BendingExplosionEventImpl;
import me.moros.bending.common.event.BindChangeEventImpl;
import me.moros.bending.common.event.CooldownChangeEventImpl;
import me.moros.bending.common.event.ElementChangeEventImpl;
import me.moros.bending.common.event.EventExceptionHandlerImpl;
import me.moros.bending.common.event.EventSubscriberImpl;
import me.moros.bending.common.event.PresetRegisterEventImpl;
import me.moros.bending.common.event.PresetUnregisterEventImpl;
import me.moros.bending.common.event.RegistryLockEventImpl;
import me.moros.bending.common.event.TickEffectEventImpl;
import me.moros.bending.common.event.UserRegisterEventImpl;
import me.moros.bending.common.event.VelocityEventImpl;
import me.moros.bending.common.logging.Logger;
import me.moros.math.Vector3d;
import org.jspecify.annotations.Nullable;

public class EventBusImpl
implements EventBus {
    private final EventRegistry<BendingEvent> eventRegistry = new SimpleEventRegistry<BendingEvent>(BendingEvent.class);
    private final bending.libraries.eventbus.bus.EventBus<BendingEvent> eventBus;
    private boolean closed = false;

    public EventBusImpl(Logger logger) {
        this(new EventExceptionHandlerImpl(logger));
    }

    protected EventBusImpl() {
        this(EventExceptionHandlerImpl.DUMMY);
    }

    private EventBusImpl(EventBus.EventExceptionHandler eventExceptionHandler) {
        this.eventBus = new SimpleEventBus<BendingEvent>(this.eventRegistry, eventExceptionHandler);
    }

    @Override
    public void shutdown() {
        this.eventRegistry.unsubscribeIf(x -> true);
        this.closed = true;
    }

    @Override
    public <T extends BendingEvent> void subscribe(Class<T> event, Consumer<? super T> subscriber, int priority) {
        if (!this.closed) {
            EventConfig eventConfig = EventConfig.of(priority, false, false);
            this.eventRegistry.subscribe(event, eventConfig, new EventSubscriberImpl<T>(subscriber));
        }
    }

    @Override
    public <T extends BendingEvent> boolean post(T event) {
        Cancellable c;
        if (this.closed) {
            throw new IllegalStateException("Eventbus has been terminated, cannot post new events.");
        }
        this.eventBus.post(event);
        return !(event instanceof Cancellable) || !(c = (Cancellable)((Object)event)).cancelled();
    }

    @Override
    public void postRegistryLockEvent(Collection<DataKey<?>> keys) {
        if (!keys.isEmpty()) {
            this.post(new RegistryLockEventImpl(keys));
        }
    }

    @Override
    public void postUserRegisterEvent(User user) {
        this.post(new UserRegisterEventImpl(user));
    }

    @Override
    public boolean postCooldownAddEvent(User user, AbilityDescription desc, long duration) {
        return this.post(new CooldownChangeEventImpl.Add(user, desc, duration));
    }

    @Override
    public void postCooldownRemoveEvent(User user, AbilityDescription desc) {
        this.post(new CooldownChangeEventImpl.Remove(user, desc));
    }

    @Override
    public void postAbilityActivationEvent(User user, AbilityDescription desc, Activation method) {
        this.post(new AbilityActivationEventImpl(user, desc, method));
    }

    @Override
    public boolean postElementChangeEvent(User user, Element element, ElementChangeEvent.ElementAction type) {
        return this.post(new ElementChangeEventImpl(user, element, type));
    }

    @Override
    public boolean postSingleBindChangeEvent(User user, int slot, @Nullable AbilityDescription desc) {
        return this.post(new BindChangeEventImpl.Single(user, slot, desc));
    }

    @Override
    public boolean postMultiBindChangeEvent(User user, Preset preset) {
        return this.post(new BindChangeEventImpl.Multi(user, preset));
    }

    @Override
    public boolean postPresetRegisterEvent(User user, Preset preset) {
        return !preset.isEmpty() && this.post(new PresetRegisterEventImpl(user, preset));
    }

    @Override
    public boolean postPresetUnregisterEvent(User user, Preset preset) {
        return !preset.isEmpty() && this.post(new PresetUnregisterEventImpl(user, preset));
    }

    @Override
    public TickEffectEvent postTickEffectEvent(User source, Entity target, int duration, BendingEffect type) {
        TickEffectEventImpl event = new TickEffectEventImpl(source, target, duration, type);
        this.post(event);
        return event;
    }

    @Override
    public BendingDamageEvent postAbilityDamageEvent(User source, AbilityDescription desc, LivingEntity target, double damage) {
        BendingDamageEventImpl event = new BendingDamageEventImpl(source, desc, target, damage);
        this.post(event);
        return event;
    }

    @Override
    public BendingExplosionEvent postExplosionEvent(User source, AbilityDescription desc, Vector3d center, Collection<Block> blocks) {
        BendingExplosionEventImpl event = new BendingExplosionEventImpl(source, desc, center, blocks);
        this.post(event);
        return event;
    }

    @Override
    public ActionLimitEvent postActionLimitEvent(User source, LivingEntity target, long duration) {
        ActionLimitEventImpl event = new ActionLimitEventImpl(source, target, duration);
        this.post(event);
        return event;
    }

    @Override
    public VelocityEvent postVelocityEvent(User source, LivingEntity target, AbilityDescription desc, Vector3d velocity) {
        VelocityEventImpl event = new VelocityEventImpl(source, target, desc, velocity);
        this.post(event);
        return event;
    }
}

