/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.data;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import me.moros.bending.common.data.DataProvider;
import me.moros.bending.common.data.DataProviderImpl;
import org.jspecify.annotations.Nullable;

public final class DataProviderBuilder<T, T1 extends T, V> {
    private final Predicate<T1> predicate;
    private @Nullable UnaryOperator<V> operator;
    private @Nullable Function<T1, V> getter;
    private @Nullable BiConsumer<T1, V> setter;

    DataProviderBuilder(Predicate<T1> predicate) {
        this.predicate = predicate;
    }

    public DataProviderBuilder<T, T1, V> valueOperator(UnaryOperator<V> operator) {
        this.operator = operator;
        return this;
    }

    public DataProviderBuilder<T, T1, V> get(Function<T1, V> getter) {
        this.getter = getter;
        return this;
    }

    public DataProviderBuilder<T, T1, V> set(BiConsumer<T1, V> setter) {
        this.setter = setter;
        return this;
    }

    DataProvider<T1, V> validateAndBuildProvider() {
        if (this.getter == null && this.setter == null) {
            throw new IllegalStateException("Cannot build empty data provider.");
        }
        return new DataProviderImpl<T1, V>(this.predicate, this.operator, this.getter, this.setter);
    }
}

