/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.config.processor;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleUnaryOperator;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.AttributeValue;
import org.jspecify.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.util.NamingSchemes;

record ConfigEntry(String name, Class<?> type) {
    private static final Map<Class<? extends Number>, DoubleFunction<Number>> CONVERTERS = Map.of(Double.class, x -> x, Integer.class, x -> (int)x, Long.class, x -> (long)x, Double.TYPE, x -> x, Integer.TYPE, x -> (int)x, Long.TYPE, x -> (long)x);

    ConfigEntry(Field field) {
        this(NamingSchemes.LOWER_CASE_DASHED.coerce(field.getName()), field.getType());
    }

    private ConfigurationNode node(ConfigurationNode parent) {
        return parent.node(new Object[]{this.name});
    }

    void modify(ConfigurationNode parent, DoubleUnaryOperator operator, Consumer<Throwable> consumer) {
        ConfigurationNode node = this.node(parent);
        double baseValue = node.getDouble();
        try {
            node.set((Object)this.toNative(operator.applyAsDouble(baseValue)));
        }
        catch (SerializationException e) {
            consumer.accept(e);
        }
    }

    AttributeValue asAttributeValue(ConfigurationNode parent, Attribute attribute, @Nullable DoubleUnaryOperator modifier) {
        double modified;
        double base = this.node(parent).getDouble();
        Number modifiedNumber = base;
        if (modifier != null && Math.abs((modified = modifier.applyAsDouble(base)) - base) > 0.001) {
            modifiedNumber = this.toNative(modified);
        }
        return AttributeValue.of(attribute, this.name, base, modifiedNumber);
    }

    private Number toNative(double value) {
        return CONVERTERS.getOrDefault(this.type(), x -> x).apply(value);
    }
}

