/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.config.processor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.AttributeValue;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.config.attribute.Modifier;
import me.moros.bending.common.config.processor.ConfigEntry;
import me.moros.bending.common.util.ReflectionUtil;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.reference.ConfigurationReference;
import org.spongepowered.configurate.reference.ValueReference;
import org.spongepowered.configurate.serialize.SerializationException;

public final class CachedConfig<T extends Configurable> {
    private final Class<T> configType;
    private final T fallback;
    private final ValueReference<T, ? extends ConfigurationNode> configRef;
    private final Collection<Map.Entry<Attribute, ConfigEntry>> entries;
    private final Map<Attribute, Collection<ConfigEntry>> map;

    private CachedConfig(Class<T> configType, T fallback, ValueReference<T, ? extends ConfigurationNode> configRef, Collection<Map.Entry<Attribute, ConfigEntry>> entries) {
        this.configType = configType;
        this.fallback = fallback;
        this.configRef = configRef;
        this.entries = List.copyOf(entries);
        this.map = new EnumMap<Attribute, Collection<ConfigEntry>>(Attribute.class);
        for (Map.Entry<Attribute, ConfigEntry> entry : this.entries) {
            this.map.computeIfAbsent(entry.getKey(), a -> new ArrayList()).add(entry.getValue());
        }
    }

    public T withAttributes(Map<Attribute, Modifier> activeModifiers, Consumer<Throwable> consumer) {
        if (activeModifiers.isEmpty()) {
            return (T)((Configurable)this.configRef.get());
        }
        ConfigurationNode parentCopy = this.configRef.node().copy();
        for (Map.Entry<Attribute, Modifier> entry : activeModifiers.entrySet()) {
            Attribute attribute = entry.getKey();
            Modifier modifier = entry.getValue();
            for (ConfigEntry handle : (Collection)this.map.getOrDefault((Object)attribute, List.of())) {
                handle.modify(parentCopy, modifier, consumer);
            }
        }
        try {
            return (T)((Configurable)parentCopy.get(this.configType, this.fallback));
        }
        catch (SerializationException e) {
            return this.fallback;
        }
    }

    public Collection<AttributeValue> readAttributes(Map<Attribute, Modifier> activeModifiers) {
        ArrayList<AttributeValue> attributes = new ArrayList<AttributeValue>();
        ConfigurationNode parent = this.configRef.node();
        for (Map.Entry<Attribute, ConfigEntry> entry : this.entries) {
            Attribute attribute = entry.getKey();
            Modifier modifier = activeModifiers.get((Object)attribute);
            attributes.add(entry.getValue().asAttributeValue(parent, attribute, modifier));
        }
        return attributes;
    }

    public static <T extends Configurable> CachedConfig<?> createFrom(ConfigurationReference<? extends ConfigurationNode> ref, Class<T> configType) throws ConfigException {
        Configurable instance = (Configurable)ReflectionUtil.tryCreateInstance(configType);
        if (instance == null) {
            throw new ConfigException("Could not create %s instance.".formatted(configType.getName()));
        }
        try {
            ValueReference valueRef = ref.referenceTo(configType, NodePath.path((Object[])instance.path().toArray()), (Object)instance);
            ArrayList<Map.Entry<Attribute, ConfigEntry>> handles = new ArrayList<Map.Entry<Attribute, ConfigEntry>>();
            for (Field field : configType.getDeclaredFields()) {
                Modifiable annotation = field.getAnnotation(Modifiable.class);
                if (annotation == null) continue;
                Attribute attribute = annotation.value();
                handles.add(Map.entry(attribute, new ConfigEntry(field)));
            }
            return new CachedConfig<Configurable>(configType, instance, valueRef, handles);
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    public static final class ConfigException
    extends Exception {
        private ConfigException(Exception e) {
            super(e.getMessage(), e);
        }

        private ConfigException(String message) {
            super(message);
        }
    }
}

