/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.command.parser;

import bending.libraries.cloud.context.CommandContext;
import bending.libraries.cloud.context.CommandInput;
import bending.libraries.cloud.parser.ArgumentParseResult;
import bending.libraries.cloud.parser.ArgumentParser;
import bending.libraries.cloud.parser.ParserDescriptor;
import bending.libraries.cloud.suggestion.BlockingSuggestionProvider;
import java.util.function.Predicate;
import me.moros.bending.api.platform.entity.player.Player;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.User;
import me.moros.bending.common.command.ContextKeys;
import me.moros.bending.common.command.parser.ComponentException;
import me.moros.bending.common.locale.Message;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;

public final class UserParser<C extends Audience>
implements ArgumentParser<C, User>,
BlockingSuggestionProvider.Strings<C> {
    private UserParser() {
    }

    @Override
    public ArgumentParseResult<User> parse(CommandContext<C> commandContext, CommandInput commandInput) {
        String input = commandInput.peekString();
        User result = input.equalsIgnoreCase("me") ? (User)commandContext.getOrDefault(ContextKeys.BENDING_PLAYER, null) : (User)Registries.BENDERS.fromString(input);
        if (result == null) {
            for (User user : Registries.BENDERS) {
                if (!input.equalsIgnoreCase(this.mapName(user))) continue;
                result = user;
                break;
            }
        }
        if (result != null) {
            commandInput.readString();
            return ArgumentParseResult.success(result);
        }
        return ArgumentParseResult.failure(new ComponentException(Message.USER_PARSE_EXCEPTION.build(input)));
    }

    @Override
    public Iterable<String> stringSuggestions(CommandContext<C> commandContext, CommandInput commandInput) {
        Predicate<User> canSee = commandContext.optional(ContextKeys.BENDING_PLAYER).map(Player.class::cast).map(u -> u::canSee).orElse(e -> true);
        return Registries.BENDERS.stream().filter(canSee).map(this::mapName).toList();
    }

    private String mapName(User user) {
        return user.get(Identity.NAME).orElseGet(() -> PlainTextComponentSerializer.plainText().serialize(user.name()));
    }

    public static <C extends Audience> ParserDescriptor<C, User> parser() {
        return ParserDescriptor.of(new UserParser<C>(), User.class);
    }
}

