/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.command.parser;

import bending.libraries.cloud.context.CommandContext;
import bending.libraries.cloud.context.CommandInput;
import bending.libraries.cloud.parser.ArgumentParseResult;
import bending.libraries.cloud.parser.ArgumentParser;
import bending.libraries.cloud.parser.ParserDescriptor;
import bending.libraries.cloud.suggestion.BlockingSuggestionProvider;
import java.util.List;
import me.moros.bending.api.ability.preset.Preset;
import me.moros.bending.api.user.PresetUser;
import me.moros.bending.common.command.ContextKeys;
import me.moros.bending.common.command.parser.ComponentException;
import me.moros.bending.common.locale.Message;
import net.kyori.adventure.audience.Audience;

public final class PresetParser<C extends Audience>
implements ArgumentParser<C, Preset>,
BlockingSuggestionProvider.Strings<C> {
    private PresetParser() {
    }

    @Override
    public ArgumentParseResult<Preset> parse(CommandContext<C> commandContext, CommandInput commandInput) {
        String input = commandInput.peekString();
        Preset preset = commandContext.optional(ContextKeys.BENDING_PLAYER).map(u -> u.presetByName(input)).orElse(null);
        if (preset != null) {
            commandInput.readString();
            return ArgumentParseResult.success(preset);
        }
        return ArgumentParseResult.failure(new ComponentException(Message.PRESET_PARSE_EXCEPTION.build(input)));
    }

    @Override
    public Iterable<String> stringSuggestions(CommandContext<C> commandContext, CommandInput commandInput) {
        return commandContext.optional(ContextKeys.BENDING_PLAYER).map(PresetUser::presets).map(p -> p.stream().map(Preset::name).toList()).orElseGet(List::of);
    }

    public static <C extends Audience> ParserDescriptor<C, Preset> parser() {
        return ParserDescriptor.of(new PresetParser<C>(), Preset.class);
    }
}

