/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.command.commands;

import bending.libraries.cloud.Command;
import bending.libraries.cloud.component.DefaultValue;
import bending.libraries.cloud.minecraft.extras.RichDescription;
import bending.libraries.cloud.parser.standard.IntegerParser;
import java.util.Set;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.ability.preset.Preset;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.common.command.CommandUtil;
import me.moros.bending.common.command.Commander;
import me.moros.bending.common.command.ContextKeys;
import me.moros.bending.common.command.Permissions;
import me.moros.bending.common.command.parser.AbilityParser;
import me.moros.bending.common.command.parser.UserParser;
import me.moros.bending.common.locale.Message;
import me.moros.bending.common.util.Initializer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;

public record BindCommand<C extends Audience>(Commander<C> commander) implements Initializer
{
    @Override
    public void init() {
        Command.Builder<C> builder = this.commander().rootBuilder();
        this.commander().register(builder.literal("bind", new String[0]).required("ability", AbilityParser.parser()).optional("slot", IntegerParser.integerParser(1, 9), DefaultValue.constant(0)).commandDescription(RichDescription.of((ComponentLike)Message.BIND_DESC.build())).permission(Permissions.BIND).senderType(this.commander().playerType()).handler(c -> this.onBind(c.get(ContextKeys.BENDING_PLAYER), (AbilityDescription)c.get("ability"), (Integer)c.get("slot"))));
        this.commander().register(builder.literal("clear", new String[0]).optional("slot", IntegerParser.integerParser(1, 9), DefaultValue.constant(0)).commandDescription(RichDescription.of((ComponentLike)Message.CLEAR_DESC.build())).permission(Permissions.BIND).senderType(this.commander().playerType()).handler(c -> this.onBindClear(c.get(ContextKeys.BENDING_PLAYER), (Integer)c.get("slot"))));
        this.commander().register(builder.literal("who", new String[0]).optional("target", UserParser.parser(), DefaultValue.parsed("me")).commandDescription(RichDescription.of((ComponentLike)Message.DISPLAY_DESC.build())).permission(Permissions.HELP).handler(c -> this.onBindList((Audience)c.sender(), (User)c.get("target"))));
    }

    private void onBind(User user, AbilityDescription ability, int slot) {
        if (!ability.canBind()) {
            Message.ABILITY_BIND_FAIL.send((Audience)user, ability.displayName());
            return;
        }
        if (!user.hasPermission(ability)) {
            Message.ABILITY_BIND_NO_PERMISSION.send((Audience)user, ability.displayName());
            return;
        }
        for (Element element : ability.elements()) {
            if (user.hasElement(element)) continue;
            Message.ABILITY_BIND_REQUIRES_ELEMENT.send((Audience)user, ability.displayName(), element.displayName());
            return;
        }
        if (slot == 0) {
            slot = user.currentSlot();
        }
        user.bindAbility(slot, ability);
        Message.ABILITY_BIND_SUCCESS.send((Audience)user, ability.displayName(), slot);
    }

    private void onBindClear(User user, int slot) {
        if (slot == 0) {
            user.bindPreset(Preset.empty());
            Message.CLEAR_ALL_SLOTS.send((Audience)user);
            return;
        }
        user.clearSlot(slot);
        Message.CLEAR_SLOT.send((Audience)user, slot);
    }

    private void onBindList(C sender, User user) {
        Component elementHover;
        Set elements = user.elements();
        if (elements.isEmpty()) {
            elementHover = Message.NO_ELEMENTS.build();
        } else {
            JoinConfiguration sep = JoinConfiguration.commas((boolean)true);
            elementHover = Component.join((JoinConfiguration)sep, elements.stream().map(Element::displayName).toList()).colorIfAbsent(ColorPalette.TEXT_COLOR);
        }
        Message.BOUND_SLOTS.send((Audience)sender, user.name().hoverEvent((HoverEventSource)HoverEvent.showText((Component)elementHover)));
        Component binds = Component.join((JoinConfiguration)JoinConfiguration.newlines(), CommandUtil.presetSlots(user.slots())).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Message.ABILITY_HOVER.build()));
        sender.sendMessage(binds);
    }
}

