/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.command.commands;

import bending.libraries.cloud.component.DefaultValue;
import bending.libraries.cloud.minecraft.extras.RichDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.AttributeValue;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.api.util.Tasker;
import me.moros.bending.common.command.Commander;
import me.moros.bending.common.command.Permissions;
import me.moros.bending.common.command.parser.AbilityParser;
import me.moros.bending.common.command.parser.UserParser;
import me.moros.bending.common.locale.Message;
import me.moros.bending.common.util.Initializer;
import me.moros.bending.common.util.ReflectionUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public record AttributeCommand<C extends Audience>(Commander<C> commander) implements Initializer
{
    @Override
    public void init() {
        this.commander().register(this.commander().rootBuilder().literal("attribute", new String[0]).required("ability", AbilityParser.parserGlobal()).optional("target", UserParser.parser(), DefaultValue.parsed("me")).commandDescription(RichDescription.of((ComponentLike)Message.ATTRIBUTE_DESC.build())).permission(Permissions.ATTRIBUTE).handler(c -> this.onViewConfig((Audience)c.sender(), (AbilityDescription)c.get("ability"), (User)c.get("target"))));
    }

    private void onViewConfig(C sender, AbilityDescription desc, User target) {
        Tasker.async().submit(() -> {
            List<Component> attributeInfo = this.collectAttributes(target, desc);
            if (attributeInfo.isEmpty()) {
                Message.ATTRIBUTE_LIST_EMPTY.send((Audience)sender, desc.displayName());
            } else {
                Message.ATTRIBUTE_LIST_HEADER.send((Audience)sender, desc.displayName());
                attributeInfo.forEach(arg_0 -> ((Audience)sender).sendMessage(arg_0));
            }
        }).exceptionally(e -> {
            this.commander().plugin().logger().warn(e.getMessage(), (Throwable)e);
            return null;
        });
    }

    private List<Component> collectAttributes(User user, AbilityDescription desc) {
        Class<Configurable> configType = ReflectionUtil.findInnerClass(desc.createAbility(), Configurable.class);
        if (configType == null) {
            return List.of();
        }
        ArrayList<Component> result = new ArrayList<Component>();
        Collection<AttributeValue> attributeValues = user.game().configProcessor().listAttributes(user, desc, configType);
        for (AttributeValue av : attributeValues) {
            Component valueComponent = Component.text((String)String.valueOf(av.finalValue()), (TextColor)ColorPalette.ACCENT).decoration(TextDecoration.UNDERLINED, av.modified());
            BuildableComponent hover = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(ColorPalette.TEXT_COLOR)).append((Component)Component.text((String)("Name: " + av.name())))).append((Component)Component.newline())).append((Component)Component.text((String)("Base: " + String.valueOf(av.baseValue()))))).build();
            BuildableComponent text = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(ColorPalette.TEXT_COLOR)).append((Component)Component.text((String)av.attribute().value()))).append((Component)Component.text((String)": "))).append(valueComponent)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)hover))).build();
            result.add((Component)text);
        }
        return result;
    }
}

