/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.collision;

import me.moros.math.Position;

public interface MortonEncoded {
    public int morton();

    public static int calculateMorton(Position position) {
        return MortonEncoded.calculateMorton(position.x(), position.y(), position.z());
    }

    public static int calculateMorton(double x, double y, double z) {
        int normalizedX = (int)Math.clamp((x + 3.0E7) * 10.0, 0.0, 6.0E8);
        int normalizedY = (int)Math.clamp((y + 3.0E7) * 10.0, 0.0, 6.0E8);
        int normalizedZ = (int)Math.clamp((z + 3.0E7) * 10.0, 0.0, 6.0E8);
        int xx = MortonEncoded.expandBits(normalizedX);
        int yy = MortonEncoded.expandBits(normalizedY);
        int zz = MortonEncoded.expandBits(normalizedZ);
        return xx * 4 + yy * 2 + zz;
    }

    private static int expandBits(int v) {
        v = (v | v << 16) & 0xFF0000FF;
        v = (v | v << 8) & 0xF00F00F;
        v = (v | v << 4) & 0xC30C30C3;
        v = (v | v << 2) & 0x49249249;
        return v;
    }
}

