/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.backup;

import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.storage.BendingStorage;
import me.moros.bending.api.user.User;
import me.moros.bending.api.user.profile.BenderProfile;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.common.Bending;
import me.moros.bending.common.backup.AbstractOperation;
import me.moros.bending.common.locale.Message;
import me.moros.tasker.Task;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.TextColor;
import org.jspecify.annotations.Nullable;

final class ImportOperation
extends AbstractOperation {
    private final Audience audience;
    private final Path path;

    ImportOperation(Bending plugin, BendingStorage storage, Audience audience, String name) {
        super(plugin, storage);
        this.audience = audience;
        this.path = plugin.path().resolve((String)(name.endsWith(".json.gz") ? name : name + ".json.gz"));
    }

    @Override
    protected boolean executeOperation() {
        if (!this.plugin.path().equals(this.path.getParent()) || !Files.isReadable(this.path)) {
            this.logToAudience((Component)Component.text((String)("Can not read file " + String.valueOf(this.path)), (TextColor)ColorPalette.FAIL));
            return false;
        }
        this.logToAudience((Component)Component.text((String)"Reading data to import...", (TextColor)ColorPalette.NEUTRAL));
        BenderProfile[] profiles = this.loadFromFile(this.path);
        if (profiles.length == 0) {
            return false;
        }
        this.logToAudience((Component)Component.text((String)"Found %d users to import.".formatted(profiles.length), (TextColor)ColorPalette.NEUTRAL));
        return this.saveUsers(profiles);
    }

    @Override
    protected void onSuccess(double seconds) {
        Message.IMPORT_SUCCESS.send(this.audience, seconds);
    }

    @Override
    protected void onFailure(@Nullable Throwable throwable) {
        this.logToAudience((Component)Component.text((String)"An error occurred while importing data.", (TextColor)ColorPalette.FAIL));
        if (throwable != null) {
            this.plugin.logger().warn(throwable.getMessage(), throwable);
        }
    }

    /*
     * Exception decompiling
     */
    private BenderProfile[] loadFromFile(Path path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean saveUsers(BenderProfile[] profiles) {
        LongAdder progress = new LongAdder();
        Task checker = this.createProgressCheckingTask(progress, profiles.length);
        return (Boolean)((CompletableFuture)this.storage.saveProfilesAsync(Arrays.asList(profiles), progress).whenComplete((result, t) -> {
            checker.cancel();
            if (Boolean.TRUE.equals(result)) {
                this.updateOnline(profiles);
            }
        })).join();
    }

    private void updateOnline(BenderProfile[] profiles) {
        Map map = Arrays.stream(profiles).collect(Collectors.toMap(BenderProfile::uuid, Function.identity()));
        List online = Registries.BENDERS.stream().toList();
        for (User user : online) {
            BenderProfile updatedProfile = (BenderProfile)map.get(user.uuid());
            if (updatedProfile == null) continue;
            user.fromProfile(updatedProfile);
        }
    }

    @Override
    protected void logProgress(int current, int total) {
        int percent = current * 100 / total;
        Message.IMPORT_PROGRESS.send(this.audience, percent);
    }

    private void logToAudience(Component msg) {
        this.audience.sendMessage(Message.brand((ComponentLike)msg));
    }

    private static /* synthetic */ BufferedReader lambda$loadFromFile$0(BufferedReader reader) throws Exception {
        return reader;
    }
}

