/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.backup;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.LongAdder;
import java.util.zip.GZIPOutputStream;
import me.moros.bending.api.storage.BendingStorage;
import me.moros.bending.api.user.profile.BenderProfile;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.common.Bending;
import me.moros.bending.common.backup.AbstractOperation;
import me.moros.bending.common.locale.Message;
import me.moros.bending.common.storage.file.loader.JsonLoader;
import me.moros.tasker.Task;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.TextColor;
import org.jspecify.annotations.Nullable;
import org.spongepowered.configurate.gson.GsonConfigurationLoader;

final class ExportOperation
extends AbstractOperation {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm").withZone(ZoneId.systemDefault());
    private final Audience audience;
    private final Path path;

    ExportOperation(Bending plugin, BendingStorage storage, Audience audience, String name) {
        super(plugin, storage);
        this.audience = audience;
        this.path = plugin.path().resolve(this.fileName(name));
    }

    private String fileName(String name) {
        return (String)(name.isEmpty() ? "bending-" + DATE_FORMAT.format(Instant.now()) : name) + ".json.gz";
    }

    @Override
    protected boolean executeOperation() {
        if (Files.exists(this.path, new LinkOption[0])) {
            this.logToAudience((Component)Component.text((String)"File already exists.", (TextColor)ColorPalette.FAIL));
            return false;
        }
        this.logToAudience((Component)Component.text((String)"Discovering users to export...", (TextColor)ColorPalette.NEUTRAL));
        BenderProfile[] profiles = this.loadUsers();
        if (profiles.length == 0) {
            return false;
        }
        Arrays.parallelSort(profiles, Comparator.comparing(BenderProfile::uuid));
        this.saveToFile(profiles);
        return true;
    }

    @Override
    protected void onSuccess(double seconds) {
        Message.EXPORT_SUCCESS.send(this.audience, this.path.toString(), seconds);
    }

    @Override
    protected void onFailure(@Nullable Throwable throwable) {
        this.logToAudience((Component)Component.text((String)"An error occurred while exporting data.", (TextColor)ColorPalette.FAIL));
        if (throwable != null) {
            this.plugin.logger().warn(throwable.getMessage(), throwable);
        }
        try {
            Files.deleteIfExists(this.path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveToFile(BenderProfile[] data) {
        try (OutputStream fos = Files.newOutputStream(this.path, new OpenOption[0]);
             GZIPOutputStream gos = new GZIPOutputStream(fos);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)gos, StandardCharsets.UTF_8);
             BufferedWriter writer = new BufferedWriter(osw);){
            GsonConfigurationLoader loader = ((GsonConfigurationLoader.Builder)((GsonConfigurationLoader.Builder)new JsonLoader().withSerializers()).lenient(false).indent(0).sink(() -> writer)).build();
            loader.save(loader.createNode(n -> n.set(PROFILES_TOKEN, Map.of("users", data))));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private BenderProfile[] loadUsers() {
        Set<UUID> uuids = this.storage.loadUuids();
        int size = uuids.size();
        this.logToAudience((Component)Component.text((String)"Found %d users to export.".formatted(size), (TextColor)ColorPalette.NEUTRAL));
        LongAdder progress = new LongAdder();
        Task checker = this.createProgressCheckingTask(progress, size);
        return (BenderProfile[])((CompletableFuture)this.storage.loadProfilesAsync(uuids, progress).handle((result, t) -> {
            checker.cancel();
            return result == null ? new BenderProfile[]{} : (BenderProfile[])result.values().toArray(BenderProfile[]::new);
        })).join();
    }

    @Override
    protected void logProgress(int current, int total) {
        int percent = current * 100 / total;
        Message.EXPORT_PROGRESS.send(this.audience, percent);
    }

    private void logToAudience(Component msg) {
        this.audience.sendMessage(Message.brand((ComponentLike)msg));
    }
}

