/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.adapter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.ObjIntConsumer;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.gui.Board;
import me.moros.bending.api.user.User;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.numbers.BlankFormat;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundResetScorePacket;
import net.minecraft.network.protocol.game.ClientboundSetDisplayObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundSetScorePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.jspecify.annotations.Nullable;

public abstract class Sidebar
implements Board {
    private static final Component ACTIVE = Component.text((String)"> ");
    private static final Component INACTIVE = Component.text((String)"> ", (TextColor)NamedTextColor.DARK_GRAY);
    private static final Component SEP = Component.text((String)" -------------- ");
    private static final String OBJECTIVE_ID = "bending-board";
    private static final String[] CHAT_CODES = new String[16];
    private final MinecraftServer server;
    private final User user;
    private final Map<AbilityDescription, IndexedScore> misc;
    private int selectedSlot;
    private boolean closed;

    private static String generateInvisibleLegacyString(int slot) {
        String hidden = CHAT_CODES[slot % CHAT_CODES.length];
        int delta = slot - CHAT_CODES.length;
        return delta <= 0 ? hidden + String.valueOf(ChatFormatting.RESET) : hidden + Sidebar.generateInvisibleLegacyString(delta);
    }

    protected Sidebar(MinecraftServer server, User user) {
        this.server = server;
        this.user = user;
        this.misc = new ConcurrentHashMap<AbilityDescription, IndexedScore>();
        this.selectedSlot = user.currentSlot();
    }

    protected void init(Component title) {
        this.trySendPackets(this.createInitialPacket(title));
    }

    private List<Packet<? super ClientGamePacketListener>> createInitialPacket(Component title) {
        ArrayList<Packet<? super ClientGamePacketListener>> packets = new ArrayList<Packet<? super ClientGamePacketListener>>(11);
        packets.addAll(this.buildInitialPackets(title));
        this.forEachSlotScore((score, slot) -> packets.addAll(this.createScore(slot, (Score)score)));
        return packets;
    }

    protected abstract Component emptySlot(int var1);

    protected abstract net.minecraft.network.chat.Component toNative(Component var1);

    @Override
    public boolean isEnabled() {
        return !this.closed;
    }

    @Override
    public void disableScoreboard() {
        if (!this.closed) {
            ArrayList<Packet<? super ClientGamePacketListener>> packets = new ArrayList<Packet<? super ClientGamePacketListener>>();
            for (int slot = 1; slot <= 9; ++slot) {
                packets.add((Packet<? super ClientGamePacketListener>)this.buildTeamPacket(slot, TeamAction.REMOVE, Score.EMPTY));
            }
            this.misc.values().forEach(indexed -> packets.add((Packet<? super ClientGamePacketListener>)this.buildTeamPacket(indexed.index(), TeamAction.REMOVE, Score.EMPTY)));
            packets.add((Packet<? super ClientGamePacketListener>)this.buildRemoveObjectivePacket());
            this.trySendPackets(packets);
            this.closed = true;
        }
    }

    @Override
    public void updateAll() {
        ArrayList<Packet<? super ClientGamePacketListener>> packets = new ArrayList<Packet<? super ClientGamePacketListener>>();
        this.forEachSlotScore((score, slot) -> packets.add((Packet<? super ClientGamePacketListener>)this.updateScore(slot, (Score)score)));
        this.trySendPackets(packets);
    }

    private Score getScoreForSlot(int slot, @Nullable AbilityDescription desc) {
        Component prefix;
        Component component = prefix = slot == this.selectedSlot ? ACTIVE : INACTIVE;
        Component suffix = desc == null ? this.emptySlot(slot) : (!this.user.onCooldown(desc) ? desc.displayName() : desc.displayName().decorate(TextDecoration.STRIKETHROUGH));
        return new Score(prefix, suffix);
    }

    private void forEachSlotScore(ObjIntConsumer<Score> consumer) {
        List<AbilityDescription> snapshot = this.user.slots().abilities();
        for (int slot = 1; slot <= 9; ++slot) {
            consumer.accept(this.getScoreForSlot(slot, snapshot.get(slot - 1)), slot);
        }
    }

    @Override
    public void activeSlot(int oldSlot, int newSlot) {
        if (this.validSlot(oldSlot) && this.validSlot(newSlot)) {
            if (this.selectedSlot != oldSlot) {
                oldSlot = this.selectedSlot;
            }
            this.selectedSlot = newSlot;
            List<ClientboundSetPlayerTeamPacket> packets = List.of(this.updateScore(oldSlot, this.getScoreForSlot(oldSlot, this.user.boundAbility(oldSlot))), this.updateScore(newSlot, this.getScoreForSlot(newSlot, this.user.boundAbility(newSlot))));
            this.trySendPackets(packets);
        }
    }

    private boolean validSlot(int slot) {
        return 1 <= slot && slot <= 9;
    }

    @Override
    public void updateMisc(AbilityDescription desc, boolean show) {
        ArrayList<Packet<? super ClientGamePacketListener>> packets = new ArrayList<Packet<? super ClientGamePacketListener>>();
        if (show) {
            if (this.misc.isEmpty()) {
                packets.addAll(this.createScore(10, new Score(SEP)));
            }
            Component miscName = INACTIVE.append(desc.displayName().decorate(TextDecoration.STRIKETHROUGH));
            IndexedScore indexed = new IndexedScore(this.pickAvailableSlot(), new Score(miscName));
            if (this.misc.putIfAbsent(desc, indexed) == null) {
                packets.addAll(this.createScore(indexed.index(), indexed.scoreEntry()));
            }
        } else {
            IndexedScore old = this.misc.remove(desc);
            if (old != null) {
                packets.addAll(this.removeScore(old.index()));
                if (this.misc.isEmpty()) {
                    packets.addAll(this.removeScore(10));
                }
            }
        }
        this.trySendPackets(packets);
    }

    private int pickAvailableSlot() {
        int idx = 11;
        for (IndexedScore indexedTeam : this.misc.values()) {
            idx = Math.max(indexedTeam.index() + 1, idx);
        }
        return idx;
    }

    private FriendlyByteBuf createByteBuf() {
        return new FriendlyByteBuf(Unpooled.buffer());
    }

    private RegistryFriendlyByteBuf createRegistryFriendlyByteBuf() {
        return new RegistryFriendlyByteBuf((ByteBuf)this.createByteBuf(), (RegistryAccess)this.server.registryAccess());
    }

    private List<Packet<? super ClientGamePacketListener>> buildInitialPackets(Component title) {
        return List.of(this.buildCreateObjectivePacket(title), this.buildSetDisplayObjectivePacket());
    }

    private ClientboundSetObjectivePacket buildCreateObjectivePacket(Component title) {
        RegistryFriendlyByteBuf buf = this.createRegistryFriendlyByteBuf();
        buf.writeUtf(OBJECTIVE_ID);
        buf.writeByte(0);
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buf, (Object)this.toNative(title));
        buf.writeEnum((Enum)ObjectiveCriteria.RenderType.INTEGER);
        NumberFormatTypes.OPTIONAL_STREAM_CODEC.encode((Object)buf, Optional.of(BlankFormat.INSTANCE));
        return (ClientboundSetObjectivePacket)ClientboundSetObjectivePacket.STREAM_CODEC.decode((Object)buf);
    }

    private ClientboundSetObjectivePacket buildRemoveObjectivePacket() {
        RegistryFriendlyByteBuf buf = this.createRegistryFriendlyByteBuf();
        buf.writeUtf(OBJECTIVE_ID);
        buf.writeByte(1);
        return (ClientboundSetObjectivePacket)ClientboundSetObjectivePacket.STREAM_CODEC.decode((Object)buf);
    }

    private ClientboundSetDisplayObjectivePacket buildSetDisplayObjectivePacket() {
        FriendlyByteBuf buf = this.createByteBuf();
        buf.writeById(DisplaySlot::id, (Object)DisplaySlot.SIDEBAR);
        buf.writeUtf(OBJECTIVE_ID);
        return (ClientboundSetDisplayObjectivePacket)ClientboundSetDisplayObjectivePacket.STREAM_CODEC.decode((Object)buf);
    }

    private List<Packet<? super ClientGamePacketListener>> createScore(int score, Score scoreEntry) {
        String objName = Sidebar.generateInvisibleLegacyString(score);
        return List.of(new ClientboundSetScorePacket(objName, OBJECTIVE_ID, -score, Optional.empty(), Optional.empty()), this.buildTeamPacket(score, TeamAction.CREATE, scoreEntry));
    }

    private List<Packet<? super ClientGamePacketListener>> removeScore(int score) {
        String objName = Sidebar.generateInvisibleLegacyString(score);
        return List.of(this.buildTeamPacket(score, TeamAction.REMOVE, Score.EMPTY), new ClientboundResetScorePacket(objName, OBJECTIVE_ID));
    }

    private ClientboundSetPlayerTeamPacket updateScore(int score, Score scoreEntry) {
        return this.buildTeamPacket(score, TeamAction.UPDATE, scoreEntry);
    }

    private ClientboundSetPlayerTeamPacket buildTeamPacket(int score, TeamAction action, Score scoreEntry) {
        RegistryFriendlyByteBuf buf = this.createRegistryFriendlyByteBuf();
        buf.writeUtf(String.valueOf(score));
        buf.writeByte(action.method);
        if (action != TeamAction.REMOVE) {
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buf, (Object)net.minecraft.network.chat.Component.literal((String)String.valueOf(score)));
            buf.writeByte(0);
            Team.Visibility.STREAM_CODEC.encode((Object)buf, (Object)Team.Visibility.ALWAYS);
            Team.CollisionRule.STREAM_CODEC.encode((Object)buf, (Object)Team.CollisionRule.ALWAYS);
            buf.writeEnum((Enum)ChatFormatting.RESET);
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buf, (Object)this.toNative(scoreEntry.prefix()));
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buf, (Object)this.toNative(scoreEntry.suffix()));
            if (action == TeamAction.CREATE) {
                buf.writeCollection(List.of(Sidebar.generateInvisibleLegacyString(score)), FriendlyByteBuf::writeUtf);
            }
        }
        return (ClientboundSetPlayerTeamPacket)ClientboundSetPlayerTeamPacket.STREAM_CODEC.decode((Object)buf);
    }

    private void trySendPackets(SequencedCollection<Packet<? super ClientGamePacketListener>> packets) {
        if (!this.closed && !packets.isEmpty()) {
            ClientboundBundlePacket packet = packets.size() == 1 ? packets.getFirst() : new ClientboundBundlePacket(packets);
            ServerPlayer player = this.server.getPlayerList().getPlayer(this.user.uuid());
            if (player != null) {
                player.connection.send((Packet)packet);
            }
        }
    }

    static {
        char prefix = '\u00a7';
        for (int i = 0; i < CHAT_CODES.length; ++i) {
            Sidebar.CHAT_CODES[i] = prefix + Integer.toHexString(i);
        }
    }

    private static enum TeamAction {
        CREATE(0),
        REMOVE(1),
        UPDATE(2);

        private final int method;

        private TeamAction(int method) {
            this.method = method;
        }
    }

    private record Score(Component prefix, Component suffix) {
        private static final Score EMPTY = new Score((Component)Component.empty(), (Component)Component.empty());

        public Score(Component prefix) {
            this(prefix, (Component)Component.empty());
        }
    }

    private record IndexedScore(int index, Score scoreEntry) {
    }
}

