/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.adapter;

import me.moros.bending.api.adapter.NativeAdapter;
import me.moros.bending.api.event.BendingDamageEvent;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.common.adapter.AbilityDamageSource;
import me.moros.bending.common.adapter.AbstractPacketUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.PlayerList;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;

public abstract class AbstractNativeAdapter
extends AbstractPacketUtil
implements NativeAdapter {
    protected AbstractNativeAdapter(PlayerList playerList) {
        super(playerList);
    }

    @Override
    public boolean setBlockFast(Block block, BlockState state) {
        BlockPos position = new BlockPos(block.blockX(), block.blockY(), block.blockZ());
        return this.adapt(block.world()).setBlock(position, this.adapt(state), 2);
    }

    @Override
    public boolean eyeInWater(Entity entity) {
        return this.adapt(entity).isEyeInFluid(FluidTags.WATER);
    }

    @Override
    public boolean eyeInLava(Entity entity) {
        return this.adapt(entity).isEyeInFluid(FluidTags.LAVA);
    }

    @Override
    public boolean tryPowerLightningRod(Block block) {
        ServerLevel level = this.adapt(block.world());
        net.minecraft.world.level.block.state.BlockState data = level.getBlockState(new BlockPos(block.blockX(), block.blockY(), block.blockZ()));
        if (data.is(Blocks.LIGHTNING_ROD)) {
            BlockPos pos = new BlockPos(block.blockX(), block.blockY(), block.blockZ());
            ((LightningRodBlock)data.getBlock()).onLightningStrike(data, (Level)this.adapt(block.world()), pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean damage(BendingDamageEvent event) {
        net.minecraft.world.entity.Entity target = this.adapt(event.target());
        int capturedInvulnerableTime = target.invulnerableTime;
        target.invulnerableTime = 0;
        TranslatableComponent deathMsg = Component.translatable((String)(event.ability().translationKey() + ".death"), (String)"bending.ability.generic.death").arguments(new ComponentLike[]{event.target().name(), event.user().name(), event.ability().displayName()});
        me.moros.bending.api.ability.DamageSource bendingSource = me.moros.bending.api.ability.DamageSource.of(event.user().name(), event.ability());
        AbilityDamageSource damageSource = new AbilityDamageSource(this.adapt(event.user()), this.adapt((Component)deathMsg), bendingSource);
        boolean result = target.hurtServer((ServerLevel)target.level(), (DamageSource)damageSource, (float)event.damage());
        target.invulnerableTime = capturedInvulnerableTime;
        return result;
    }
}

