/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water.sequence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.SelectedSource;
import me.moros.bending.api.ability.state.State;
import me.moros.bending.api.ability.state.StateChain;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.GridIterator;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.api.util.material.WaterMaterials;
import me.moros.bending.common.ability.water.IceCrawl;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Vector3d;

public class Iceberg
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private StateChain states;
    private Vector3d tip;
    private final List<GridIterator> lines = new ArrayList<GridIterator>();
    private final Collection<Block> blocks = new HashSet<Block>();
    private boolean started = false;

    public Iceberg(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, IceCrawl.class)) {
            return false;
        }
        Block source = user.find(this.userConfig.selectRange, WaterMaterials::isWaterOrIceBendable);
        if (source == null) {
            return false;
        }
        this.states = new StateChain().addState(SelectedSource.create(user, source, this.userConfig.selectRange + 2.0)).start();
        this.removalPolicy = Policies.builder().add(Policies.NOT_SNEAKING).build();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.started) {
            ListIterator<GridIterator> iterator = this.lines.listIterator();
            while (iterator.hasNext()) {
                if (ThreadLocalRandom.current().nextInt(1 + this.lines.size()) == 0) continue;
                GridIterator blockLine = iterator.next();
                if (blockLine.hasNext()) {
                    this.formIce(blockLine.next());
                    continue;
                }
                iterator.remove();
            }
            if (this.lines.isEmpty()) {
                this.formIce(this.tip);
                return Updatable.UpdateResult.REMOVE;
            }
            return Updatable.UpdateResult.CONTINUE;
        }
        if (!this.user.hasAbilitySelected("icespike")) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.states.update();
    }

    private void formIce(Position pos) {
        boolean canPlaceAir;
        Block block = this.user.world().blockAt(pos);
        if (this.blocks.contains(block) || TempBlock.MANAGER.isTemp(block) || MaterialUtil.isUnbreakable(block)) {
            return;
        }
        if (!this.user.canBuild(block)) {
            return;
        }
        this.blocks.add(block);
        boolean bl = canPlaceAir = !MaterialUtil.isWater(block) && !MaterialUtil.isAir(block);
        if (canPlaceAir) {
            TempBlock.air().duration(BendingProperties.instance().iceRevertTime() + this.userConfig.regenDelay).build(block);
        }
        BlockType ice = ThreadLocalRandom.current().nextBoolean() ? BlockType.PACKED_ICE : BlockType.ICE;
        TempBlock.builder(ice).bendable(true).duration(BendingProperties.instance().iceRevertTime()).build(block);
    }

    public static void launch(User user) {
        if (user.hasAbilitySelected("icespike")) {
            user.game().abilityManager(user.worldKey()).firstInstance(user, Iceberg.class).ifPresent(Iceberg::launch);
        }
    }

    private void launch() {
        if (this.started) {
            return;
        }
        State state = this.states.current();
        if (state instanceof SelectedSource) {
            state.complete();
            Optional<Block> src = this.states.chainStore().stream().findAny();
            if (src.isEmpty()) {
                return;
            }
            Vector3d origin = src.get().center();
            Vector3d target = this.user.rayTrace(this.userConfig.selectRange + this.userConfig.length).cast(this.user.world()).entityCenterOrPosition();
            Vector3d direction = ((Vector3d)target.subtract(origin)).normalize();
            this.tip = (Vector3d)origin.add((Position)direction.multiply(this.userConfig.length));
            Vector3d targetLocation = ((Vector3d)origin.add((Position)direction.multiply(this.userConfig.length - 1.0))).center();
            double radius = FastMath.ceil(0.2 * this.userConfig.length);
            for (Block block : this.user.world().nearbyBlocks(origin, radius, WaterMaterials::isWaterOrIceBendable)) {
                if (!this.user.canBuild(block)) continue;
                this.lines.add(this.line(block.center(), targetLocation));
            }
            if (this.lines.size() < 5) {
                this.lines.clear();
                return;
            }
            this.started = true;
        }
    }

    private GridIterator line(Vector3d origin, Vector3d target) {
        Vector3d direction = (Vector3d)target.subtract(origin);
        int length = FastMath.round(target.distance(origin));
        return GridIterator.create(origin, direction, length);
    }

    @Override
    public void onDestroy() {
        if (!this.blocks.isEmpty()) {
            this.user.addCooldown(this.description(), this.userConfig.cooldown);
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 15000L;
        @Modifiable(value=Attribute.SELECTION)
        private double selectRange = 16.0;
        @Modifiable(value=Attribute.DURATION)
        private long regenDelay = 30000L;
        @Modifiable(value=Attribute.HEIGHT)
        private double length = 16.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "water", "sequences", "iceberg");
        }
    }
}

