/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Position;
import me.moros.math.Vector3i;

public class WaterBubble
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final Collection<Block> bubble = new HashSet<Block>();
    private Position center;
    private double radius = 1.5;
    private long nextUpdateTime = 0L;

    public WaterBubble(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, WaterBubble.class)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.center = user.location().toVector3i();
        this.removalPolicy = Policies.builder().add(Policies.NOT_SNEAKING).add(SwappedSlotsRemovalPolicy.of(this.description())).add(ExpireRemovalPolicy.of(this.userConfig.duration)).build();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        Vector3i current;
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        long time = System.currentTimeMillis();
        if (time < this.nextUpdateTime) {
            return Updatable.UpdateResult.CONTINUE;
        }
        this.nextUpdateTime = time + 250L;
        boolean updateBubble = false;
        if (this.radius < this.userConfig.radius) {
            this.radius += this.userConfig.speed;
            updateBubble = true;
        }
        if (!(current = this.user.location().toVector3i()).equals(this.center)) {
            this.center = current;
            updateBubble = true;
        }
        if (updateBubble) {
            this.pushWater();
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    private boolean checkBlockOutOfRange(Block block) {
        if (block.distanceSq(this.user.location()) > this.radius * this.radius) {
            this.fastClean(block);
            return true;
        }
        return false;
    }

    private void pushWater() {
        this.bubble.removeIf(this::checkBlockOutOfRange);
        for (Block block : this.user.world().nearbyBlocks(this.user.location(), this.radius, MaterialUtil::isWater)) {
            if (!this.user.canBuild(block) || TempBlock.MANAGER.isTemp(block)) continue;
            TempBlock.air().fixWater(false).build(block).ifPresent(tb -> this.bubble.add(block));
        }
    }

    private void fastClean(Block block) {
        TempBlock.MANAGER.get(block).filter(tb -> MaterialUtil.isAir(tb.block())).ifPresent(TempBlock::revert);
    }

    @Override
    public void onDestroy() {
        for (Block block : this.bubble) {
            TempBlock tb;
            if (!MaterialUtil.isAir(block) || (tb = (TempBlock)TempBlock.MANAGER.get(block).orElse(null)) == null) continue;
            double distance = block.distanceSq(this.center);
            double factor = distance > this.radius ? 0.3 : 1.0 - distance / (1.5 * this.radius);
            long delay = (long)(1500.0 * factor);
            tb.revert();
            TempBlock.air().duration(delay).build(block);
        }
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 3000L;
        @Modifiable(value=Attribute.DURATION)
        private long duration = 15000L;
        @Modifiable(value=Attribute.RADIUS)
        private double radius = 5.0;
        @Modifiable(value=Attribute.SPEED)
        private double speed = 0.5;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "water", "waterbubble");
        }
    }
}

