/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.ability.common.basic.BlockStream;
import me.moros.bending.api.ability.state.State;
import me.moros.bending.api.ability.state.StateChain;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.common.ability.water.WaterRing;
import me.moros.bending.common.ability.water.sequence.WaterGimbal;
import me.moros.math.Vector3d;

public class Torrent
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private StateChain states;
    private WaterRing ring;

    public Torrent(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, WaterGimbal.class)) {
            return false;
        }
        Optional<Torrent> torrent = user.game().abilityManager(user.worldKey()).firstInstance(user, Torrent.class);
        if (torrent.isPresent()) {
            torrent.get().onClick();
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.ring = WaterRing.getOrCreateInstance(user);
        if (this.ring == null) {
            return false;
        }
        this.tryLaunch();
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        return true;
    }

    private void onClick() {
        if (this.states == null) {
            this.tryLaunch();
        } else {
            State state = this.states.current();
            if (state instanceof TorrentStream) {
                TorrentStream torrentStream = (TorrentStream)state;
                torrentStream.clicked = true;
            }
        }
    }

    private void tryLaunch() {
        List<Block> sources;
        if (this.ring.isReady() && !this.user.onCooldown(this.description()) && !(sources = this.ring.complete()).isEmpty()) {
            this.states = new StateChain(sources).addState(new TorrentStream()).start();
            this.user.addCooldown(this.description(), this.userConfig.cooldown);
        }
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.states != null) {
            return this.states.update();
        }
        if (this.ring.isDestroyed()) {
            return Updatable.UpdateResult.REMOVE;
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    @Override
    public void onDestroy() {
        State current;
        if (this.states != null && (current = this.states.current()) instanceof TorrentStream) {
            TorrentStream torrentStream = (TorrentStream)current;
            torrentStream.cleanAll();
        }
    }

    @Override
    public Collection<Collider> colliders() {
        State state;
        if (this.states != null && (state = this.states.current()) instanceof TorrentStream) {
            TorrentStream torrentStream = (TorrentStream)state;
            return torrentStream.colliders();
        }
        return List.of();
    }

    private class TorrentStream
    extends BlockStream {
        private final Set<UUID> affectedEntities;
        private boolean shouldFreeze;
        private boolean clicked;

        public TorrentStream() {
            super(Torrent.this.user, BlockType.WATER, Torrent.this.userConfig.range, 18);
            this.affectedEntities = new HashSet<UUID>();
            this.shouldFreeze = false;
            this.clicked = false;
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            if (entity instanceof LivingEntity) {
                if (this.clicked && !this.shouldFreeze) {
                    this.shouldFreeze = true;
                }
                if (this.affectedEntities.add(entity.uuid())) {
                    double damage = this.shouldFreeze ? Torrent.this.userConfig.damage : Torrent.this.userConfig.damage + Torrent.this.userConfig.freezeBonusDamage;
                    entity.damage(damage, Torrent.this.user, Torrent.this.description());
                }
            }
            Vector3d velocity = (Vector3d)((Vector3d)this.direction.withY(Math.min(this.direction.y(), Torrent.this.userConfig.knockup))).multiply(Torrent.this.userConfig.knockback);
            entity.applyVelocity(Torrent.this, velocity);
            return false;
        }

        @Override
        public void postRender() {
            Block head;
            if (this.shouldFreeze) {
                this.freeze();
                return;
            }
            if (ThreadLocalRandom.current().nextInt(5) == 0 && (head = (Block)this.stream.peekFirst()) != null) {
                SoundEffect.WATER.play(head);
            }
        }

        public boolean freeze() {
            if (!this.clicked || this.stream.isEmpty()) {
                return false;
            }
            Block head = (Block)this.stream.getFirst();
            if (head == null) {
                return false;
            }
            this.cleanAll();
            TempBlock.Builder builder = TempBlock.ice().duration(Torrent.this.userConfig.freezeDuration);
            this.stream.forEach(builder::build);
            this.stream.clear();
            return true;
        }

        @Override
        public void onBlockHit(Block block) {
            Ray ray = Ray.of(block.center(), this.direction);
            if (this.clicked) {
                if (this.freeze()) {
                    FragileStructure.tryDamageStructure(block, 8, ray);
                }
                return;
            }
            FragileStructure.tryDamageStructure(block, 1, ray);
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 5000L;
        @Modifiable(value=Attribute.RANGE)
        private double range = 32.0;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 3.0;
        @Modifiable(value=Attribute.DAMAGE)
        private double freezeBonusDamage = 2.0;
        @Modifiable(value=Attribute.DURATION)
        private long freezeDuration = 12500L;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockback = 1.0;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockup = 0.2;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "water", "torrent");
        }
    }
}

