/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.ActionType;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.ability.common.SelectedSource;
import me.moros.bending.api.ability.common.basic.AbstractLine;
import me.moros.bending.api.ability.state.State;
import me.moros.bending.api.ability.state.StateChain;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.entity.display.BlockDisplayBuilder;
import me.moros.bending.api.platform.entity.display.Transformation;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.ActionLimiter;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.temporal.TempDisplayEntity;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.api.util.material.WaterMaterials;
import me.moros.math.Vector3d;
import me.moros.math.Vector3i;

public class IceCrawl
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private StateChain states;
    private Line iceLine;

    public IceCrawl(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (method == Activation.ATTACK) {
            user.game().abilityManager(user.worldKey()).firstInstance(user, IceCrawl.class).ifPresent(IceCrawl::launch);
            return false;
        }
        this.user = user;
        this.loadConfig();
        Block source = user.find(this.userConfig.selectRange, WaterMaterials::isWaterOrIceBendable);
        if (source == null) {
            return false;
        }
        Optional<IceCrawl> line = user.game().abilityManager(user.worldKey()).firstInstance(user, IceCrawl.class);
        if (method == Activation.SNEAK && line.isPresent()) {
            State state = line.get().states.current();
            if (state instanceof SelectedSource) {
                SelectedSource selectedSource = (SelectedSource)state;
                selectedSource.reselect(source);
            }
            return false;
        }
        this.states = new StateChain().addState(SelectedSource.create(user, source, this.userConfig.selectRange)).start();
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.iceLine != null) {
            return this.iceLine.update();
        }
        return this.states.update();
    }

    private void launch() {
        if (this.iceLine != null) {
            return;
        }
        State state = this.states.current();
        if (state instanceof SelectedSource) {
            state.complete();
            Optional<Block> src = this.states.chainStore().stream().findAny();
            if (src.isPresent()) {
                this.iceLine = new Line(src.get());
                this.removalPolicy = Policies.defaults();
                this.user.addCooldown(this.description(), this.userConfig.cooldown);
            }
        }
    }

    @Override
    public Collection<Collider> colliders() {
        return this.iceLine == null ? List.of() : List.of(this.iceLine.collider());
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 6000L;
        @Modifiable(value=Attribute.DURATION)
        private long freezeDuration = 1500L;
        @Modifiable(value=Attribute.RANGE)
        private double range = 22.0;
        @Modifiable(value=Attribute.SELECTION)
        private double selectRange = 8.0;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 2.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "water", "icecrawl");
        }
    }

    private class Line
    extends AbstractLine {
        public Line(Block source) {
            super(IceCrawl.this.user, source, IceCrawl.this.userConfig.range, 0.7, true);
            this.skipVertical = true;
            this.diagonalsPredicate = MaterialUtil::isTransparentOrWater;
        }

        @Override
        public void render(Vector3d location) {
            double x = ThreadLocalRandom.current().nextDouble(-0.125, 0.125);
            double z = ThreadLocalRandom.current().nextDouble(-0.125, 0.125);
            int blockLight = IceCrawl.this.user.world().blockLightLevel(location);
            int skyLight = IceCrawl.this.user.world().skyLightLevel(location);
            ((TempDisplayEntity.Builder)((TempDisplayEntity.Builder)((TempDisplayEntity.Builder)TempDisplayEntity.builder(BlockType.PACKED_ICE).gravity(true)).duration(1200L)).velocity(Vector3d.of(0.0, 0.16, 0.0))).edit(d -> ((BlockDisplayBuilder)d.transformation(Transformation.scaled(0.75))).brightness(blockLight, skyLight)).build(IceCrawl.this.user.world(), location.add(x, -0.75, z));
            BlockType.PACKED_ICE.asParticle(location).count(6).offset(0.25, 0.125, 0.25).spawn(IceCrawl.this.user.world());
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(5) == 0) {
                SoundEffect.ICE.play(IceCrawl.this.user.world(), location);
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            entity.damage(IceCrawl.this.userConfig.damage, IceCrawl.this.user, IceCrawl.this.description());
            if (entity.valid() && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                Vector3i lightLoc = entity.location().toVector3i();
                int blockLight = entity.world().blockLightLevel(lightLoc);
                int skyLight = entity.world().skyLightLevel(lightLoc);
                ((TempDisplayEntity.Builder)TempDisplayEntity.builder(BlockType.PACKED_ICE).duration(IceCrawl.this.userConfig.freezeDuration)).edit(c -> c.brightness(blockLight, skyLight)).build(IceCrawl.this.user.world(), entity.location().add(0.0, -0.2, 0.0));
                ActionLimiter.builder().limit(ActionType.MOVE, new ActionType[0]).duration(IceCrawl.this.userConfig.freezeDuration).build(IceCrawl.this.user, livingEntity);
            }
            return true;
        }

        @Override
        public boolean onBlockHit(Block block) {
            if (MaterialUtil.isWater(block)) {
                TempBlock.ice().duration(BendingProperties.instance().iceRevertTime()).build(block);
            }
            return WorldUtil.tryCoolLava(IceCrawl.this.user, block);
        }

        @Override
        protected boolean isValidBlock(Block block) {
            if (!MaterialUtil.isTransparentOrWater(block)) {
                return false;
            }
            Block below = block.offset(Direction.DOWN);
            return WaterMaterials.isWaterOrIceBendable(below) || below.type().isCollidable();
        }

        @Override
        protected void onCollision(Vector3d point) {
            FragileStructure.tryDamageStructure(IceCrawl.this.user.world().blockAt(point), 5, Ray.of(this.collider.position(), this.direction));
        }
    }
}

