/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.water;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.ActionType;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityTypeTag;
import me.moros.bending.api.platform.entity.EntityUtil;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.item.EquipmentSlot;
import me.moros.bending.api.platform.item.Inventory;
import me.moros.bending.api.platform.item.PlayerInventory;
import me.moros.bending.api.platform.potion.PotionEffect;
import me.moros.bending.api.platform.sound.Sound;
import me.moros.bending.api.temporal.ActionLimiter;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.ColorPalette;
import me.moros.bending.api.util.ExpiringSet;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.data.DataKey;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.qte.QuickTimeEvent;
import me.moros.bending.common.util.stamina.StaminaBar;
import me.moros.math.FastMath;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.TriState;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;

public class BloodBending
extends AbilityInstance {
    private static final DataKey<Mode> KEY = KeyUtil.data("bloodbending-mode", Mode.class);
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final Map<UUID, BloodBendingEffect> targets = new HashMap<UUID, BloodBendingEffect>();
    private final ExpiringSet<UUID> disarmedTargets = new ExpiringSet(20000L);
    private StaminaBar stamina;

    public BloodBending(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        boolean attackActivation = method == Activation.ATTACK;
        BloodBending instance = user.game().abilityManager(user.worldKey()).firstInstance(user, BloodBending.class).orElse(null);
        if (instance != null) {
            if (attackActivation) {
                instance.tryDisarm();
            } else {
                instance.acquireTargets();
            }
            return false;
        }
        if (attackActivation) {
            return false;
        }
        this.loadConfig();
        TextComponent title = Component.text((String)"Stamina", (TextColor)ColorPalette.WATER);
        this.stamina = StaminaBar.builder().bar(BossBar.bossBar((Component)title, (float)1.0f, (BossBar.Color)BossBar.Color.BLUE, (BossBar.Overlay)BossBar.Overlay.PROGRESS)).maxStamina(this.userConfig.stamina.capacity).staminaRegen(this.userConfig.stamina.regen).build((Audience)this.user);
        if (this.acquireTargets()) {
            this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).build();
            return true;
        }
        return false;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (!this.user.sneaking()) {
            this.reset();
        } else {
            this.targets.entrySet().removeIf(e -> ((BloodBendingEffect)e.getValue()).update() == Updatable.UpdateResult.REMOVE);
        }
        return this.stamina.update();
    }

    private void tryDisarm() {
        for (BloodBendingEffect effect : this.targets.values()) {
            if (!this.disarmedTargets.add(effect.target.uuid())) continue;
            effect.attemptDisarm();
        }
    }

    private boolean acquireTargets() {
        Mode mode = this.user.store().get(KEY).orElse(Mode.SINGLE);
        ArrayList<Entity> collectedEntities = new ArrayList<Entity>();
        if (mode == Mode.SINGLE) {
            Entity direct = this.user.rayTrace(this.userConfig.selectRange + 1.0).raySize(0.6).cast(this.user.world()).entity();
            if (direct != null) {
                collectedEntities.add(direct);
            }
        } else {
            Vector3d center = this.user.center();
            CollisionUtil.handle(this.user, Sphere.of(center, this.userConfig.radius), collectedEntities::add);
            collectedEntities.sort(Comparator.comparingDouble(e -> e.center().distanceSq(center)));
        }
        for (Entity entity : collectedEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            this.tryTrackEntity(living).ifPresent(effect -> this.targets.put(living.uuid(), (BloodBendingEffect)effect));
        }
        return !this.targets.isEmpty();
    }

    @Override
    public void onDestroy() {
        this.reset();
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
    }

    private void reset() {
        this.stamina.reset();
        this.targets.values().forEach(BloodBendingEffect::onRemove);
        this.targets.clear();
    }

    private Optional<BloodBendingEffect> tryTrackEntity(LivingEntity target) {
        if (!this.targets.containsKey(target.uuid()) && !EntityTypeTag.SENSITIVE_TO_SMITE.containsValue(target.type()) && this.targets.size() < this.userConfig.maxTargets && this.stamina.drainCost(this.userConfig.stamina.initialCost)) {
            return Optional.of(new BloodBendingEffect(this, target, this.userConfig.stamina.drainPerTarget));
        }
        return Optional.empty();
    }

    public static void switchMode(User user) {
        if (user.hasAbilitySelected("bloodbending") && user.store().canEdit(KEY)) {
            Mode mode = user.store().toggle(KEY, Mode.SINGLE);
            user.sendActionBar((Component)Component.text((String)("Target: " + mode.name()), (TextColor)ColorPalette.TEXT_COLOR));
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 20000L;
        @Modifiable(value=Attribute.SELECTION)
        private double selectRange = 8.0;
        @Modifiable(value=Attribute.RADIUS)
        private double radius = 5.0;
        @Modifiable(value=Attribute.AMOUNT)
        private int maxTargets = 5;
        private StaminaConfig stamina = new StaminaConfig();

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "water", "bloodbending");
        }
    }

    @ConfigSerializable
    private static final class StaminaConfig {
        @Comment(value="Total stamina capacity")
        private int capacity = 200;
        @Comment(value="Initial stamina cost when starting to bloodbend a target")
        private int initialCost = 20;
        @Comment(value="Base stamina drain per second")
        private int drainPerTarget = 15;
        @Comment(value="Stamina regeneration per second")
        private int regen = 25;

        private StaminaConfig() {
        }
    }

    private static final class BloodBendingEffect
    implements Updatable {
        private static final float INITIAL_SPEED_FACTOR = 1.0f;
        private static final float MAX_SPEED_FACTOR = 1.6f;
        private static final float MAX_PANIC_SPEED_FACTOR = 2.4f;
        private final BloodBending parent;
        private final LivingEntity target;
        private final Vector3d targetLocation;
        private final double distanceSquared;
        private final int drain;
        private boolean limited;
        private int ticks;
        private int nextHeartbeatTick;
        private boolean heartbeatAlt;
        private float speedFactor;
        private float maxSpeedFactor;
        private ResistDisarm disarm;
        private TriState sneaking;

        private BloodBendingEffect(BloodBending parent, LivingEntity target, int drain) {
            this.parent = parent;
            this.target = target;
            this.targetLocation = (Vector3d)target.location().withY(0.5 + parent.user().eyeLocation().y());
            this.distanceSquared = Math.pow(parent.userConfig.radius + 2.0, 2.0);
            this.drain = drain;
            this.limited = false;
            this.ticks = 0;
            this.nextHeartbeatTick = ThreadLocalRandom.current().nextInt(3);
            this.heartbeatAlt = false;
            this.speedFactor = 1.0f;
            this.maxSpeedFactor = 1.6f;
            this.sneaking = TriState.NOT_SET;
        }

        @Override
        public Updatable.UpdateResult update() {
            if (!this.isValidTarget() || !this.parent.stamina.tickingDrain(this.drain)) {
                this.onRemove();
                return Updatable.UpdateResult.REMOVE;
            }
            this.heartbeat();
            this.limitTarget();
            this.handleDisarmUpdate();
            EntityUtil.tryAddPotion(this.target, PotionEffect.DARKNESS, 100, 0);
            Vector3d randomizedNearbyLocation = VectorUtil.gaussianOffset(this.targetLocation, 0.25);
            Vector3d direction = (Vector3d)randomizedNearbyLocation.subtract(this.target.location());
            double factor = 0.2 * direction.length();
            this.target.applyVelocity(this.parent, (Vector3d)direction.normalize().multiply(Math.clamp(factor, -0.5, 0.5)));
            return Updatable.UpdateResult.CONTINUE;
        }

        private void panic() {
            this.maxSpeedFactor = 2.4f;
        }

        private void resetPanic() {
            this.maxSpeedFactor = 1.6f;
        }

        private void handleHeartbeatSpeed() {
            float signum = Math.signum(this.maxSpeedFactor - this.speedFactor);
            if (signum != 0.0f) {
                float delta = (this.maxSpeedFactor - 1.0f) / 40.0f;
                this.speedFactor = Math.clamp(this.speedFactor + signum * delta, 1.0f, this.maxSpeedFactor);
            }
        }

        private void heartbeat() {
            this.handleHeartbeatSpeed();
            if (++this.ticks < this.nextHeartbeatTick) {
                return;
            }
            if (this.disarm != null && this.disarm.isFocused()) {
                return;
            }
            int ticksPerCycle = FastMath.ceil(20.0f / this.speedFactor);
            this.nextHeartbeatTick = this.ticks + FastMath.ceil((float)ticksPerCycle * (this.heartbeatAlt ? 0.65f : 0.35f));
            float pitch = this.heartbeatAlt ? 1.3f : 1.8f;
            this.target.playSound(Sound.ENTITY_WARDEN_HEARTBEAT.asEffect(0.4f * this.speedFactor, pitch).sound());
            this.heartbeatAlt = !this.heartbeatAlt;
        }

        private void limitTarget() {
            if (this.limited) {
                return;
            }
            this.limited = ActionLimiter.builder().limit(EnumSet.complementOf(EnumSet.of(ActionType.MOVE))).showBar(false).duration(30000L).build(this.parent.user(), this.target).isPresent();
        }

        private void handleDisarmUpdate() {
            if (this.disarm == null) {
                return;
            }
            boolean targetSneaking = this.target.sneaking();
            if (this.sneaking == TriState.NOT_SET) {
                if (!targetSneaking) {
                    this.sneaking = TriState.FALSE;
                }
            } else if (this.sneaking == TriState.FALSE && targetSneaking) {
                this.sneaking = TriState.TRUE;
                this.disarm.attempt();
            }
            if (this.disarm.update() == Updatable.UpdateResult.REMOVE) {
                this.disarm = null;
            }
        }

        private void onRemove() {
            if (this.disarm != null) {
                this.disarm.onRemove();
            }
            ActionLimiter.MANAGER.get(this.target.uuid()).ifPresent(ActionLimiter::revert);
        }

        private boolean isValidTarget() {
            if (!this.target.valid()) {
                return false;
            }
            User user = this.parent.user();
            return this.target.world().equals(user.world()) && this.target.location().distanceSq(user.eyeLocation()) <= this.distanceSquared;
        }

        private void attemptDisarm() {
            int cost;
            if (this.disarm == null && this.parent.stamina.hasAtLeast(cost = 5 * this.parent.userConfig.stamina.drainPerTarget)) {
                this.disarm = new ResistDisarm(this, cost);
                this.panic();
            }
        }
    }

    private static enum Mode {
        SINGLE,
        MULTI;

    }

    private static final class ResistDisarm
    extends QuickTimeEvent {
        private final BloodBendingEffect parent;
        private final int staminaCost;

        private ResistDisarm(BloodBendingEffect parent, int staminaCost) {
            super((Audience)parent.target, (Component)Component.text((String)"Resist Disarm"), 50);
            this.parent = parent;
            this.staminaCost = staminaCost;
        }

        @Override
        protected void onSuccess() {
            Sound.ENTITY_PLAYER_ATTACK_WEAK.asEffect(1.0f, 0.4f).play(this.parent.target.world(), this.parent.target.center());
            this.parent.parent.stamina.drainCost(this.staminaCost);
            this.parent.resetPanic();
        }

        @Override
        protected void onFailure() {
            Vector3d center = this.parent.target.center();
            Sound.ENTITY_PLAYER_ATTACK_CRIT.asEffect(1.0f, 1.8f).play(this.parent.target.world(), center);
            Sound.BLOCK_BONE_BLOCK_BREAK.asEffect(1.0f, 1.2f).play(this.parent.target.world(), center);
            Inventory inventory = this.parent.target.inventory();
            if (inventory instanceof PlayerInventory) {
                PlayerInventory inv = (PlayerInventory)inventory;
                inv.dropItem(EquipmentSlot.MAINHAND);
                inv.dropItem(EquipmentSlot.OFFHAND);
            }
            this.parent.parent.stamina.fill(this.staminaCost);
        }
    }
}

