/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.fire;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.collision.Collision;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.collision.raytrace.CompositeRayTrace;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockProperties;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.entity.EntityType;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.item.InventoryUtil;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.temporal.TempLight;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingExplosion;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.common.ability.earth.MetalCable;
import me.moros.math.Position;
import me.moros.math.Rotation;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;
import org.jspecify.annotations.Nullable;

public class Lightning
extends AbilityInstance {
    private static final double POINT_DISTANCE = 0.2;
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final Set<UUID> affectedEntities = new HashSet<UUID>();
    private Collection<Collider> colliders = new ArrayList<Collider>();
    private ListIterator<LineSegment> arcIterator;
    private Vector3d direction;
    private boolean launched = false;
    private boolean exploded = false;
    private boolean canExplode = true;
    private double factor;
    private long startTime;

    public Lightning(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).userInstances(user, Lightning.class).anyMatch(l -> !l.launched)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.removalPolicy = Policies.builder().add(ExpireRemovalPolicy.of(this.userConfig.overchargeTime)).add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        this.startTime = System.currentTimeMillis();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.launched) {
            return this.advanceLightning() ? Updatable.UpdateResult.CONTINUE : Updatable.UpdateResult.REMOVE;
        }
        if (this.user.sneaking()) {
            long deltaTime;
            if (ThreadLocalRandom.current().nextInt(3) == 0) {
                SoundEffect.LIGHTNING_CHARGING.play(this.user.world(), this.user.eyeLocation());
            }
            if ((deltaTime = System.currentTimeMillis() - this.startTime) > this.userConfig.minChargeTime) {
                Vector3d spawnLoc = this.user.mainHandSide();
                double offset = (double)deltaTime / (3.0 * (double)this.userConfig.overchargeTime);
                ParticleBuilder.rgb((Position)spawnLoc, "#01E1FF").offset(offset).spawn(this.user.world());
                if (deltaTime > this.userConfig.maxChargeTime) {
                    Particle.ELECTRIC_SPARK.builder(spawnLoc).spawn(this.user.world());
                }
            }
        } else {
            this.launch();
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    private boolean tryInteractWithCable(Vector3d origin, @Nullable MetalCable cable, boolean directed) {
        if (cable == null) {
            for (Entity entity : this.user.world().nearbyEntities(origin, 2.0, e -> e.type() == EntityType.ARROW)) {
                MetalCable ability = entity.get(MetalCable.CABLE_KEY).orElse(null);
                if (ability == null || this.user.uuid().equals(ability.user().uuid())) continue;
                cable = ability;
                break;
            }
        }
        if (cable != null) {
            cable.electrify(origin, directed).ifPresent(this::onEntityHit);
            this.removalPolicy = (u, d) -> true;
            return true;
        }
        return false;
    }

    private void launch() {
        if (this.launched) {
            return;
        }
        long deltaTime = System.currentTimeMillis() - this.startTime;
        this.factor = 1.0;
        if (deltaTime >= this.userConfig.maxChargeTime) {
            this.factor = this.userConfig.chargeFactor;
        } else if (deltaTime >= this.userConfig.minChargeTime) {
            double deltaChargeTime = this.userConfig.maxChargeTime - this.userConfig.minChargeTime;
            double deltaFactor = (this.userConfig.chargeFactor - this.factor) * (double)(deltaTime - this.userConfig.minChargeTime) / deltaChargeTime;
            this.factor += deltaFactor;
        } else {
            this.removalPolicy = (u, d) -> true;
            return;
        }
        if (this.tryInteractWithCable(this.user.eyeLocation(), null, true)) {
            return;
        }
        double distance = this.userConfig.range * this.factor;
        Vector3d origin = this.user.eyeLocation();
        Vector3d target = (Vector3d)origin.add((Position)this.user.direction().multiply(distance));
        CompositeRayTrace rayTrace = this.user.rayTrace(distance).raySize(1.5).cast(this.user.world());
        Vector3d point = null;
        if (rayTrace.hit()) {
            point = rayTrace.position();
        }
        this.direction = ((Vector3d)target.subtract(origin)).normalize();
        this.arcIterator = new Arc(origin, target, point).iterator();
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
        this.removalPolicy = Policies.defaults();
        this.launched = true;
    }

    private boolean advanceLightning() {
        double counter = 0.0;
        while (this.arcIterator.hasNext() && counter < this.userConfig.speed) {
            LineSegment segment = this.arcIterator.next();
            CompositeRayTrace result = this.user.rayTrace(segment.start, segment.direction).ignoreLiquids(true).raySize(0.3).cast(this.user.world());
            this.direction = segment.direction;
            if (!segment.isFork) {
                if (ThreadLocalRandom.current().nextInt(6) == 0) {
                    SoundEffect.LIGHTNING.play(this.user.world(), segment.mid);
                }
                counter += segment.length;
                Block block = result.block();
                if (block != null) {
                    if (Platform.instance().nativeAdapter().tryPowerLightningRod(block)) {
                        return false;
                    }
                    this.explode(result.position(), block);
                    return false;
                }
            }
            if (!this.user.canBuild(segment.end)) {
                return false;
            }
            this.colliders.add(Sphere.of(segment.mid, 0.2));
            this.renderSegment(segment);
            if (!this.electrocuteAround(result.entity())) continue;
            return false;
        }
        return this.arcIterator.hasNext();
    }

    private void renderSegment(LineSegment segment) {
        for (Vector3d v : segment) {
            Particle.WAX_OFF.builder(v).spawn(this.user.world());
        }
        TempLight.builder(15).build(this.user.world().blockAt(segment.mid));
    }

    private boolean handleRedirection(Iterable<Entity> entitiesToCheck) {
        for (Entity e : entitiesToCheck) {
            Lightning other;
            User bendingUser = (User)Registries.BENDERS.get(e.uuid());
            if (bendingUser == null || (other = (Lightning)this.user.game().abilityManager(this.user.worldKey()).userInstances(bendingUser, Lightning.class).filter(l -> !l.launched).findFirst().orElse(null)) == null) continue;
            other.startTime = 0L;
            return true;
        }
        return false;
    }

    private boolean electrocuteAround(@Nullable Entity entity) {
        if (entity != null) {
            Sphere collider = Sphere.of(entity.center(), this.userConfig.radius);
            ArrayList<Entity> entities = new ArrayList<Entity>();
            CollisionUtil.handle(this.user, collider, entities::add);
            if (this.handleRedirection(entities)) {
                return true;
            }
            entities.forEach(this::onEntityHit);
        }
        return false;
    }

    private void onEntityHit(Entity entity) {
        if (this.affectedEntities.add(entity.uuid())) {
            LivingEntity livingEntity;
            boolean hasMetalArmor;
            entity.setProperty(EntityProperties.CHARGED, true);
            boolean hitWater = entity.inWater();
            boolean grounded = entity.isOnGround();
            boolean bl = hasMetalArmor = entity instanceof LivingEntity && InventoryUtil.hasMetalArmor(livingEntity = (LivingEntity)entity);
            double dmgFactor = hitWater ? 2.0 : (grounded && hasMetalArmor ? 0.5 : 1.0);
            double damage = this.factor * dmgFactor * this.userConfig.damage;
            entity.damage(damage, this.user, this.description());
            if (grounded) {
                this.canExplode = false;
            }
            Particle.ELECTRIC_SPARK.builder(entity.center()).count(8).offset(0.3).spawn(this.user.world());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean touchLiquid(Vector3d center, Block block) {
        Block centerBlock = this.user.world().blockAt(center);
        if (block.type().isLiquid()) return true;
        if (centerBlock.type().isLiquid()) {
            return true;
        }
        if (WorldUtil.FACES.stream().map(block::offset).map(Block::type).anyMatch(BlockProperties::isLiquid)) {
            return true;
        }
        if (centerBlock.equals(block)) return false;
        if (!WorldUtil.FACES.stream().map(centerBlock::offset).map(Block::type).anyMatch(BlockProperties::isLiquid)) return false;
        return true;
    }

    private void explode(Vector3d center, Block block) {
        if (this.exploded || !this.canExplode || this.touchLiquid(center, block)) {
            return;
        }
        this.exploded = true;
        FragileStructure.tryDamageStructure(block, 0, Ray.of(center, this.direction));
        BendingExplosion.builder().size(this.userConfig.explosionRadius).damage(this.userConfig.explosionDamage).fireTicks(0).breakBlocks(true).sound(6.0f, 1.0f).buildAndExplode(this, center);
        this.removalPolicy = (u, d) -> true;
    }

    @Override
    public Collection<Collider> colliders() {
        return this.launched ? List.copyOf(this.colliders) : List.of();
    }

    @Override
    public void onDestroy() {
        if (!this.launched && this.userConfig.overchargeTime > 0L && System.currentTimeMillis() > this.startTime + this.userConfig.overchargeTime) {
            SoundEffect.LIGHTNING.play(this.user.world(), this.user.location());
            this.user.addCooldown(this.description(), this.userConfig.cooldown);
            this.user.damage(this.userConfig.overchargeDamage, this.user, this.description());
        }
    }

    @Override
    public void onCollision(Collision collision) {
        Ability ability = collision.collidedAbility();
        if (ability instanceof MetalCable) {
            MetalCable cable = (MetalCable)ability;
            this.tryInteractWithCable(collision.colliderSelf().position(), cable, false);
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 6000L;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 1.5;
        @Modifiable(value=Attribute.RANGE)
        private double range = 15.0;
        @Modifiable(value=Attribute.RADIUS)
        private double radius = 1.5;
        @Modifiable(value=Attribute.SPEED)
        private double speed = 2.0;
        @Modifiable(value=Attribute.CHARGE_TIME)
        private long minChargeTime = 1000L;
        @Modifiable(value=Attribute.CHARGE_TIME)
        private long maxChargeTime = 3000L;
        @Modifiable(value=Attribute.STRENGTH)
        private double chargeFactor = 2.0;
        @Modifiable(value=Attribute.DAMAGE)
        private double explosionDamage = 3.0;
        @Modifiable(value=Attribute.RADIUS)
        private double explosionRadius = 2.5;
        @Modifiable(value=Attribute.DURATION)
        private long overchargeTime = 8000L;
        @Modifiable(value=Attribute.DAMAGE)
        private double overchargeDamage = 4.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "fire", "lightning");
        }
    }

    private static final class Arc
    implements Iterable<LineSegment> {
        private final ThreadLocalRandom rand = ThreadLocalRandom.current();
        private final List<LineSegment> segments;
        private final Vector3d start;
        private static final double OFFSET = 1.6;
        private static final double FORK_CHANCE = 0.5;

        private Arc(Vector3d start, Vector3d end, @Nullable Vector3d target) {
            this.start = start;
            Function<LineSegment, Vector3d> f = target == null ? ls -> this.randomOffset((LineSegment)ls, 1.2000000000000002) : ls -> target;
            LinkedList<LineSegment> startingSegments = new LinkedList<LineSegment>(this.displaceMidpoint(new LineSegment(start, end), f, 0.0));
            this.segments = this.generateRecursively(1.6, startingSegments, 0.25);
        }

        private List<LineSegment> displaceMidpoint(LineSegment segment, Function<LineSegment, Vector3d> function, double forkChance) {
            Vector3d offsetPoint = function.apply(segment);
            LineSegment first = new LineSegment(segment.start, offsetPoint, segment.isFork);
            LineSegment second = new LineSegment(offsetPoint, segment.end, segment.isFork);
            if (forkChance > 0.0 && this.rand.nextDouble() < forkChance) {
                Vector3d forkEnd = this.randomDirection(first, offsetPoint, segment.length * 0.75);
                return List.of(first, new LineSegment(offsetPoint, forkEnd, true), second);
            }
            return List.of(first, second);
        }

        private List<LineSegment> generateRecursively(double maxOffset, List<LineSegment> lines, double maxSegmentLength) {
            int size = lines.size();
            ListIterator<LineSegment> it = lines.listIterator();
            while (it.hasNext()) {
                LineSegment toSplit = it.next();
                if (toSplit.isFork && toSplit.length < 0.1 || !toSplit.isFork && toSplit.length < maxSegmentLength) continue;
                List<LineSegment> split = this.displaceMidpoint(toSplit, ls -> this.randomOffset((LineSegment)ls, maxOffset), 0.5);
                it.remove();
                split.forEach(it::add);
            }
            if (size != lines.size()) {
                return this.generateRecursively(maxOffset * 0.5, lines, maxSegmentLength);
            }
            return List.copyOf(lines);
        }

        private Vector3d randomOffset(LineSegment segment, double maxOffset) {
            double length = maxOffset * 0.5 * (this.rand.nextGaussian() + 1.0);
            double angle = this.rand.nextDouble(Math.PI * 2);
            return (Vector3d)segment.mid.add(VectorUtil.orthogonal(segment.direction, angle, length));
        }

        private Vector3d randomDirection(LineSegment segment, Vector3d offset, double maxLength) {
            double angle = 0.7853981633974483;
            Vector3d axis = (Vector3d)offset.subtract(this.start);
            Rotation rotation = Rotation.from(axis, this.rand.nextDouble(-angle, angle));
            Vector3d angledVector = rotation.applyTo(segment.direction);
            double halfLength = 0.5 * maxLength;
            return (Vector3d)offset.add((Position)angledVector.normalize().multiply(halfLength + this.rand.nextDouble(halfLength)));
        }

        @Override
        public ListIterator<LineSegment> iterator() {
            return this.segments.listIterator();
        }
    }

    private static final class LineSegment
    implements Iterable<Vector3d> {
        private final Vector3d start;
        private final Vector3d end;
        private final Vector3d direction;
        private final Vector3d mid;
        private final double length;
        private final boolean isFork;

        private LineSegment(Vector3d start, Vector3d end) {
            this(start, end, false);
        }

        private LineSegment(Vector3d start, Vector3d end, boolean isFork) {
            this.start = start;
            this.end = end;
            this.isFork = isFork;
            Vector3d dir = (Vector3d)end.subtract(start);
            this.direction = dir.normalize();
            this.length = dir.length();
            this.mid = (Vector3d)start.add((Position)this.direction.multiply(this.length * 0.5));
        }

        @Override
        public Iterator<Vector3d> iterator() {
            return new Iterator<Vector3d>(){
                private double f = 0.0;

                @Override
                public boolean hasNext() {
                    return this.f < length;
                }

                @Override
                public Vector3d next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("Reached segment end.");
                    }
                    this.f += 0.2;
                    return (Vector3d)start.add((Position)direction.multiply(this.f));
                }
            };
        }
    }
}

