/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.fire;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.ability.common.basic.ParticleStream;
import me.moros.bending.api.collision.Collision;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockProperties;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.temporal.TempLight;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.common.ability.AbilityInitializer;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Rotation;
import me.moros.math.Vector3d;
import org.spongepowered.configurate.objectmapping.meta.Comment;

public class FlameRush
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private FireStream stream;
    private final Set<UUID> affectedEntities = new HashSet<UUID>();
    private boolean charging;
    private boolean fullyCharged = false;
    private long startTime;

    public FlameRush(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, FlameRush.class)) {
            return false;
        }
        if (Policies.UNDER_WATER.test(user, this.description()) || Policies.UNDER_LAVA.test(user, this.description())) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.startTime = System.currentTimeMillis();
        this.charging = true;
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).add(Policies.UNDER_WATER).add(Policies.UNDER_LAVA).build();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.charging) {
            if (this.user.sneaking()) {
                Vector3d spawnLoc = this.user.mainHandSide();
                ParticleBuilder.fire(this.user, spawnLoc).spawn(this.user.world());
                if (System.currentTimeMillis() >= this.startTime + this.userConfig.maxChargeTime) {
                    Particle.SMOKE.builder(spawnLoc).spawn(this.user.world());
                }
            } else {
                this.launch();
            }
            return Updatable.UpdateResult.CONTINUE;
        }
        return this.stream.update();
    }

    public boolean isFullyCharged() {
        return this.fullyCharged;
    }

    private void launch() {
        long time = System.currentTimeMillis();
        double deltaTime = time - this.startTime;
        double factor = 1.0;
        if (deltaTime >= (double)this.userConfig.maxChargeTime) {
            factor = this.userConfig.chargeFactor;
            this.fullyCharged = true;
        } else if (deltaTime > 0.3 * (double)this.userConfig.maxChargeTime) {
            double deltaFactor = (this.userConfig.chargeFactor - factor) * deltaTime / (double)this.userConfig.maxChargeTime;
            factor += deltaFactor;
        }
        this.charging = false;
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
        Vector3d origin = this.user.location().add(0.0, 1.2, 0.0);
        Vector3d lookingDir = (Vector3d)this.user.direction().multiply(this.userConfig.range * factor);
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        this.stream = new FireStream(Ray.of(origin, lookingDir), factor);
    }

    @Override
    public Collection<Collider> colliders() {
        return this.stream == null ? List.of() : List.of(this.stream.collider());
    }

    @Override
    public void onCollision(Collision collision) {
        Ability collidedAbility = collision.collidedAbility();
        if (this.fullyCharged && collision.removeSelf()) {
            if (AbilityInitializer.layer3.containsValue(collidedAbility.description().key())) {
                collision.removeOther(true);
            } else {
                collision.removeSelf(false);
            }
        } else if (collidedAbility instanceof FlameRush) {
            FlameRush other = (FlameRush)collidedAbility;
            double collidedFactor = other.stream.factor;
            if (this.stream.factor > collidedFactor + 0.1) {
                collision.removeSelf(false);
            }
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 10000L;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 2.0;
        @Modifiable(value=Attribute.RANGE)
        private double range = 16.0;
        @Modifiable(value=Attribute.SPEED)
        private double speed = 1.2;
        @Comment(value="How much the damage and range are multiplied by at full charge")
        @Modifiable(value=Attribute.STRENGTH)
        private double chargeFactor = 2.0;
        @Comment(value="How many milliseconds it takes to fully charge")
        @Modifiable(value=Attribute.CHARGE_TIME)
        private long maxChargeTime = 2500L;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "fire", "flamerush");
        }
    }

    private class FireStream
    extends ParticleStream {
        private static final SoundEffect LOUD_FIRE = SoundEffect.FIRE.with(2.0f, 1.0f);
        private static final double ORIGINAL_COLLISION_RADIUS = 0.5;
        private final double factor;
        private Vector3d streamDirection;
        private double currentPoint;
        private int ticks;

        public FireStream(Ray ray, double factor) {
            super(FlameRush.this.user, ray, FlameRush.this.userConfig.speed / 3.0, 0.5);
            this.currentPoint = 0.0;
            this.ticks = 0;
            this.factor = factor;
            this.canCollide = BlockProperties::isLiquid;
            this.steps = 3;
            this.streamDirection = this.dir;
        }

        @Override
        public void render(Vector3d location) {
            this.currentPoint += 0.10471975511965977;
            double radius = 0.2 * this.factor + 0.6 * (this.distanceTravelled / this.maxRange);
            int amount = FastMath.ceil(12.0 * radius);
            double offset = 0.5 * radius;
            ParticleBuilder.fire(FlameRush.this.user, location).count(amount).offset(offset).spawn(FlameRush.this.user.world());
            Vector3d vec = Rotation.from(this.streamDirection, this.currentPoint).applyTo((Position)Vector3d.ONE.multiply(radius));
            Vector3d spiral1 = (Vector3d)location.add(vec);
            Vector3d spiral2 = (Vector3d)location.subtract(vec);
            ParticleBuilder.fire(FlameRush.this.user, spiral1).spawn(FlameRush.this.user.world());
            ParticleBuilder.fire(FlameRush.this.user, spiral2).spawn(FlameRush.this.user.world());
            Particle.SMOKE.builder(spiral1).spawn(FlameRush.this.user.world());
            Particle.SMOKE.builder(spiral2).spawn(FlameRush.this.user.world());
            this.collisionRadius = 0.5 + 0.7 * radius;
            TempLight.builder(++this.ticks).build(FlameRush.this.user.world().blockAt(location));
        }

        @Override
        protected Vector3d controlDirection() {
            if (FlameRush.this.description().equals(FlameRush.this.user.selectedAbility())) {
                this.streamDirection = (Vector3d)((Vector3d)this.streamDirection.add((Position)FlameRush.this.user.direction().multiply(0.08))).normalize().multiply(this.speed);
            }
            return this.streamDirection;
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(3) == 0) {
                LOUD_FIRE.play(FlameRush.this.user.world(), location);
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            if (FlameRush.this.affectedEntities.add(entity.uuid())) {
                BendingEffect.FIRE_TICK.apply(FlameRush.this.user, entity);
                entity.damage(FlameRush.this.userConfig.damage * this.factor, FlameRush.this.user, FlameRush.this.description());
                entity.applyVelocity(FlameRush.this, (Vector3d)this.streamDirection.normalize().multiply(0.7 * this.factor));
            }
            return false;
        }

        @Override
        public boolean onBlockHit(Block block) {
            FragileStructure.tryDamageStructure(block, FastMath.round(8.0 * this.factor), Ray.of(this.collider().position(), this.streamDirection));
            return true;
        }
    }
}

