/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.fire;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.OBB;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityType;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.temporal.TempLight;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.ExpiringSet;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.common.ability.fire.HeatControl;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;
import org.jspecify.annotations.Nullable;

public class FireWall
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Collection<Vector3d> bases;
    private final Map<Block, TempLight> lights = new HashMap<Block, TempLight>();
    private Collection<TempLight> oldLights;
    private final ExpiringSet<UUID> cachedEntities = new ExpiringSet(500L);
    private final ExpiringSet<UUID> damagedEntities = new ExpiringSet(500L);
    private OBB collider;
    private Vector3d center;
    private Vector3d direction;
    private double currentHeight;
    private double height;
    private double distanceTravelled = 0.0;
    private long lastSneakTime;
    private long nextRenderTime;
    private int ticks = 5;

    public FireWall(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        this.center = this.getValidBase(this.userConfig.height / 2.0);
        if (this.center == null) {
            return false;
        }
        this.direction = ((Vector3d)user.direction().withY(0.0)).normalize();
        this.bases = this.setupBases();
        if (this.bases.isEmpty()) {
            return false;
        }
        this.height = this.userConfig.height;
        this.currentHeight = 1.0;
        double hw = 0.5 + this.userConfig.width / 2.0;
        AABB aabb = AABB.of(Vector3d.of(-hw, -0.5, -0.75), Vector3d.of(hw, this.userConfig.moveMaxHeight, 0.75));
        this.collider = OBB.of(aabb, Vector3d.PLUS_J, Math.toRadians(user.yaw())).at(this.center);
        this.removalPolicy = Policies.builder().add(ExpireRemovalPolicy.of(this.userConfig.duration)).build();
        this.nextRenderTime = 0L;
        user.addCooldown(this.description(), this.userConfig.cooldown);
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.bases.isEmpty() || this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.currentHeight < this.height) {
            this.currentHeight += this.height / 60.0;
        }
        long time = System.currentTimeMillis();
        if (this.user.sneaking() && this.user.hasAbilitySelected("firewall")) {
            if (this.lastSneakTime == 0L) {
                this.lastSneakTime = time;
            }
            if (time >= this.lastSneakTime + 250L) {
                this.lastSneakTime = time;
                this.move();
            }
        } else {
            this.lastSneakTime = 0L;
        }
        ++this.ticks;
        if (time >= this.nextRenderTime) {
            this.nextRenderTime = time + 200L;
            this.renderWall();
        }
        CollisionUtil.handle(this.user, this.collider, this::onEntityHit, false, true);
        return Updatable.UpdateResult.CONTINUE;
    }

    private void renderWall() {
        for (Vector3d base : this.bases) {
            for (double h = 0.0; h <= this.currentHeight; h += 0.8) {
                Vector3d pos = base.add(0.0, h, 0.0);
                Block block = this.user.world().blockAt(pos);
                if (!MaterialUtil.isTransparent(block)) continue;
                TempLight.builder(this.ticks).rate(1).duration(this.userConfig.duration).build(block).map(TempLight::lock).ifPresent(l -> this.lights.put(block, (TempLight)l));
                if (h == 0.0) {
                    ParticleBuilder.fire(this.user, pos).count(6).offset(0.5, 0.25, 0.5).extra(0.01).spawn(this.user.world());
                } else {
                    double speed = 1.0 - h / (2.0 * this.currentHeight);
                    for (int i = 0; i < 2; ++i) {
                        Vector3d center = VectorUtil.gaussianOffset(pos, 0.4);
                        ParticleBuilder.fire(this.user, center).count(0).offset(0.0, 1.0, 0.0).extra(0.07 * speed).spawn(this.user.world());
                    }
                }
                if (ThreadLocalRandom.current().nextInt(15) != 0) continue;
                SoundEffect.FIRE.play(this.user.world(), pos);
            }
        }
        this.cleanupLight(this.oldLights);
    }

    private @Nullable Vector3d getValidBase(double searchHeight) {
        Vector3d center = this.user.rayTrace(this.userConfig.range).ignoreLiquids(false).blocks(this.user.world()).position();
        for (double i = 0.0; i <= searchHeight; i += 0.5) {
            Vector3d check = (Vector3d)center.subtract(0.0, i, 0.0);
            Block block = this.user.world().blockAt(check);
            if (!this.user.canBuild(block) || !MaterialUtil.isTransparent(block) || !block.offset(Direction.DOWN).type().isSolid()) continue;
            return check;
        }
        return null;
    }

    private Collection<Vector3d> setupBases() {
        this.oldLights = new ArrayList<TempLight>(this.lights.values());
        this.lights.clear();
        double hw = this.userConfig.width / 2.0;
        Vector3d side = this.direction.cross(Vector3d.PLUS_J).normalize();
        ArrayList<Vector3d> possibleBases = new ArrayList<Vector3d>();
        for (double i = -hw; i < hw; i += 0.9) {
            Vector3d check = (Vector3d)this.center.add((Position)side.multiply(i));
            double baseY = (double)FastMath.floor(check.y()) + 0.25;
            possibleBases.add((Vector3d)check.withY(baseY));
        }
        return possibleBases;
    }

    private void move() {
        if (this.distanceTravelled >= this.userConfig.moveRange) {
            return;
        }
        Vector3d currentPosition = (Vector3d)this.center.add(this.direction);
        Block check = this.user.world().blockAt(currentPosition);
        if (!MaterialUtil.isTransparent(check) || !this.user.canBuild(check)) {
            return;
        }
        this.center = currentPosition;
        this.collider = this.collider.at(this.center);
        this.bases = this.setupBases();
        this.distanceTravelled += this.direction.length();
        if (this.currentHeight < this.userConfig.moveMaxHeight) {
            double deltaHeight = (this.userConfig.moveMaxHeight - this.userConfig.height) / this.userConfig.moveRange;
            this.currentHeight += deltaHeight;
        }
    }

    private boolean onEntityHit(Entity entity) {
        double requiredY = this.center.y() + this.currentHeight;
        if (entity.location().y() > requiredY) {
            return false;
        }
        if (entity.isProjectile()) {
            if (entity.type() != EntityType.TRIDENT) {
                entity.remove();
            }
            return true;
        }
        if (!(entity instanceof LivingEntity)) {
            entity.applyVelocity(this, Vector3d.ZERO);
            return true;
        }
        if (!this.cachedEntities.contains(entity.uuid())) {
            if (Registries.BENDERS.getIfExists(entity.uuid()).map(HeatControl::canBurn).orElse(true).booleanValue()) {
                Vector3d pos;
                double d;
                BendingEffect.FIRE_TICK.apply(this.user, entity);
                if (this.damagedEntities.add(entity.uuid())) {
                    entity.damage(this.userConfig.damage, this.user, this.description());
                }
                Vector3d altVel = (d = this.direction.dot((Position)(pos = entity.center()).subtract(this.center))) > 0.0 ? this.direction : this.direction.negate();
                Vector3d velocity = (Vector3d)((Vector3d)pos.subtract(this.collider.closestPosition(pos))).normalize(altVel).multiply(this.userConfig.knockback);
                entity.applyVelocity(this, velocity);
                return true;
            }
            this.cachedEntities.add(entity.uuid());
        }
        return false;
    }

    private void cleanupLight(@Nullable Collection<TempLight> collection) {
        if (collection != null && !collection.isEmpty()) {
            collection.forEach(TempLight::unlock);
            collection.clear();
        }
    }

    @Override
    public void onDestroy() {
        this.cleanupLight(this.oldLights);
        this.cleanupLight(this.lights.values());
    }

    @Override
    public Collection<Collider> colliders() {
        return List.of(this.collider);
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 20000L;
        @Modifiable(value=Attribute.HEIGHT)
        private double height = 4.0;
        @Modifiable(value=Attribute.RADIUS)
        private double width = 6.0;
        @Modifiable(value=Attribute.RANGE)
        private double range = 3.0;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 0.5;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockback = 0.33;
        @Modifiable(value=Attribute.DURATION)
        private long duration = 8000L;
        @Modifiable(value=Attribute.RANGE)
        private double moveRange = 7.0;
        @Modifiable(value=Attribute.HEIGHT)
        private double moveMaxHeight = 8.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "fire", "firewall");
        }
    }
}

