/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.fire;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.MultiUpdatable;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.ability.common.basic.ParticleStream;
import me.moros.bending.api.collision.Collision;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.collision.geometry.RayUtil;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockProperties;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.temporal.TempLight;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Vector3d;

public class FireBurst
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final MultiUpdatable<FireStream> streams = MultiUpdatable.empty();
    private final Set<UUID> affectedEntities = new HashSet<UUID>();
    private boolean released;
    private long startTime;

    public FireBurst(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (method == Activation.ATTACK) {
            user.game().abilityManager(user.worldKey()).firstInstance(user, FireBurst.class).ifPresent(b -> b.release(true));
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        this.released = false;
        this.startTime = System.currentTimeMillis();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (!this.released) {
            boolean charged = this.isCharged();
            if (charged) {
                ParticleBuilder.fire(this.user, this.user.mainHandSide()).spawn(this.user.world());
                if (!this.user.sneaking()) {
                    this.release(false);
                }
            } else if (!this.user.sneaking()) {
                return Updatable.UpdateResult.REMOVE;
            }
            return Updatable.UpdateResult.CONTINUE;
        }
        return this.streams.update();
    }

    @Override
    public Collection<Collider> colliders() {
        return this.streams.stream().map(ParticleStream::collider).toList();
    }

    @Override
    public void onCollision(Collision collision) {
        Collider collider = collision.colliderSelf();
        this.streams.removeIf(stream -> stream.collider().equals(collider));
        if (collision.removeSelf() && !this.streams.isEmpty()) {
            collision.removeSelf(false);
        }
    }

    private boolean isCharged() {
        return System.currentTimeMillis() >= this.startTime + this.userConfig.chargeTime;
    }

    private void release(boolean cone) {
        if (this.released || !this.isCharged()) {
            return;
        }
        this.released = true;
        Collection<Ray> rays = cone ? RayUtil.cone(this.user, this.userConfig.coneRange) : RayUtil.sphere(this.user, this.userConfig.sphereRange);
        rays.forEach(r -> this.streams.add(new FireStream((Ray)r)));
        this.removalPolicy = Policies.defaults();
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 6000L;
        @Modifiable(value=Attribute.CHARGE_TIME)
        private long chargeTime = 2500L;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 3.0;
        @Modifiable(value=Attribute.FIRE_TICKS)
        private int fireTicks = 35;
        @Modifiable(value=Attribute.SPEED)
        private double speed = 0.8;
        @Modifiable(value=Attribute.RANGE)
        private double sphereRange = 7.0;
        @Modifiable(value=Attribute.RANGE)
        private double coneRange = 11.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "fire", "fireburst");
        }
    }

    private class FireStream
    extends ParticleStream {
        private long nextRenderTime;
        private int ticks;

        public FireStream(Ray ray) {
            super(FireBurst.this.user, ray, FireBurst.this.userConfig.speed, 1.0);
            this.ticks = 3;
            this.canCollide = BlockProperties::isLiquid;
        }

        @Override
        public void render(Vector3d location) {
            long time = System.currentTimeMillis();
            if (time >= this.nextRenderTime) {
                ParticleBuilder.fire(FireBurst.this.user, location).offset(0.2).extra(0.01).spawn(FireBurst.this.user.world());
                this.nextRenderTime = time + 75L;
            }
            TempLight.builder(++this.ticks).build(FireBurst.this.user.world().blockAt(location));
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(12) == 0) {
                SoundEffect.FIRE.play(FireBurst.this.user.world(), location);
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            if (FireBurst.this.affectedEntities.add(entity.uuid())) {
                BendingEffect.FIRE_TICK.apply(FireBurst.this.user, entity, FireBurst.this.userConfig.fireTicks);
                entity.damage(FireBurst.this.userConfig.damage, FireBurst.this.user, FireBurst.this.description());
                entity.applyVelocity(FireBurst.this, (Vector3d)this.ray.direction().normalize().multiply(0.5));
            }
            return true;
        }

        @Override
        public boolean onBlockHit(Block block) {
            Vector3d reverse = this.ray.direction().negate();
            WorldUtil.tryLightBlock(block);
            double igniteRadius = 1.5;
            Vector3d standing = FireBurst.this.user.location().add(0.0, 0.5, 0.0);
            for (Block b : FireBurst.this.user.world().nearbyBlocks(this.collider().position(), igniteRadius)) {
                if (standing.distanceSq(b.center()) < 4.0 || !FireBurst.this.user.canBuild(b) || FireBurst.this.user.rayTrace(b.center(), reverse).range(igniteRadius + 2.0).blocks(FireBurst.this.user.world()).hit() || !MaterialUtil.isIgnitable(b)) continue;
                TempBlock.fire().duration(BendingProperties.instance().fireRevertTime(1000L)).ability(FireBurst.this).build(b);
            }
            FragileStructure.tryDamageStructure(block, 4, Ray.of(this.collider().position(), this.ray.direction()));
            return true;
        }
    }
}

