/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.fire;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.MultiUpdatable;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.BlockLine;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.FastMath;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;

public class Blaze
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final MultiUpdatable<FireStream> streams = MultiUpdatable.empty();
    private final Set<Block> affectedBlocks = new HashSet<Block>();

    public Blaze(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, Blaze.class)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        return this.release(method == Activation.ATTACK);
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    private boolean release(boolean cone) {
        double range = cone ? this.userConfig.coneRange : this.userConfig.ringRange;
        Vector3d origin = this.user.location().center();
        Vector3d dir = ((Vector3d)this.user.direction().withY(0.0)).normalize();
        if (cone) {
            double deltaAngle = Math.PI / (3.0 * range);
            VectorUtil.createArc(dir, Vector3d.PLUS_J, deltaAngle, FastMath.ceil(range / 1.5)).forEach(v -> this.streams.add(new FireStream(Ray.of(origin, (Vector3d)v.multiply(range)))));
        } else {
            VectorUtil.circle(dir, Vector3d.PLUS_J, FastMath.ceil(6.0 * range)).forEach(v -> this.streams.add(new FireStream(Ray.of(origin, (Vector3d)v.multiply(range)))));
        }
        if (this.streams.update() == Updatable.UpdateResult.REMOVE) {
            return false;
        }
        this.removalPolicy = Policies.defaults();
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
        return true;
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.streams.update();
    }

    @Override
    public void onDestroy() {
        if (!this.affectedBlocks.isEmpty()) {
            this.user.addCooldown(this.description(), this.userConfig.cooldown);
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 1000L;
        @Modifiable(value=Attribute.RANGE)
        private double coneRange = 10.0;
        @Modifiable(value=Attribute.RANGE)
        private double ringRange = 7.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "fire", "blaze");
        }
    }

    private class FireStream
    extends BlockLine {
        public FireStream(Ray ray) {
            super(Blaze.this.user, ray);
            this.interval = 70L;
        }

        @Override
        public boolean isValidBlock(Block block) {
            return MaterialUtil.isFire(block) || MaterialUtil.isIgnitable(block);
        }

        @Override
        public void render(Block block) {
            if (!Blaze.this.affectedBlocks.add(block)) {
                return;
            }
            TempBlock.fire().duration(500L).ability(Blaze.this).build(block);
            if (ThreadLocalRandom.current().nextInt(6) == 0) {
                SoundEffect.FIRE.play(block);
            }
        }
    }
}

