/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth.sequence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.ParticleStream;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockProperties;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.Sound;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;

public class EarthShards
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final Collection<ShardStream> streams = new ArrayList<ShardStream>();
    private int firedShots = 0;
    private long nextFireTime;

    public EarthShards(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        this.removalPolicy = Policies.defaults();
        user.addCooldown(this.description(), this.userConfig.cooldown);
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        long time;
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.firedShots < this.userConfig.maxShots && (time = System.currentTimeMillis()) >= this.nextFireTime) {
            this.nextFireTime = time + this.userConfig.interval;
            this.launch(this.user.handSide(false), this.user.handSide(true));
        }
        this.streams.removeIf(stream -> stream.update() == Updatable.UpdateResult.REMOVE);
        return this.streams.isEmpty() && this.firedShots >= this.userConfig.maxShots ? Updatable.UpdateResult.REMOVE : Updatable.UpdateResult.CONTINUE;
    }

    private void launch(Vector3d left, Vector3d right) {
        Vector3d target = this.user.rayTrace(this.userConfig.range).cast(this.user.world()).position();
        double distance = target.distance(this.user.eyeLocation());
        for (int i = 0; i < 2 && this.firedShots < this.userConfig.maxShots; ++i) {
            ++this.firedShots;
            Vector3d origin = i == 0 ? right : left;
            Vector3d dir = (Vector3d)VectorUtil.gaussianOffset(target, distance * this.userConfig.spread).subtract(origin);
            this.streams.add(new ShardStream(Ray.of(origin, dir)));
        }
    }

    @Override
    public Collection<Collider> colliders() {
        return this.streams.stream().map(ParticleStream::collider).toList();
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 10000L;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 0.5;
        @Modifiable(value=Attribute.RANGE)
        private double range = 16.0;
        @Modifiable(value=Attribute.SPEED)
        private double speed = 0.8;
        @Modifiable(value=Attribute.AMOUNT)
        private int maxShots = 10;
        private double spread = 0.02;
        private long interval = 100L;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "sequences", "earthshards");
        }
    }

    private class ShardStream
    extends ParticleStream {
        private final Vector3d smallDir;
        private final int renderSteps;

        public ShardStream(Ray ray) {
            super(EarthShards.this.user, ray, EarthShards.this.userConfig.speed, 0.75);
            this.canCollide = BlockProperties::isLiquid;
            this.renderSteps = FastMath.ceil(EarthShards.this.userConfig.speed / 0.05);
            this.smallDir = (Vector3d)ray.direction().normalize().multiply(0.05);
            Sound.BLOCK_STONE_BREAK.asEffect(1.0f, 2.0f).play(EarthShards.this.user.world(), ray.position());
        }

        @Override
        public void render(Vector3d location) {
            int max = this.distanceTravelled <= 0.0 ? 1 : this.renderSteps;
            for (int i = 0; i < max; ++i) {
                ParticleBuilder.rgb(location.subtract((Position)this.smallDir.multiply(i)), "#555555", 0.15f).spawn(EarthShards.this.user.world());
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            entity.damage(EarthShards.this.userConfig.damage, EarthShards.this.user, EarthShards.this.description());
            return true;
        }

        @Override
        public boolean onBlockHit(Block block) {
            return true;
        }
    }
}

