/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.MultiUpdatable;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.BlockLine;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempDisplayEntity;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.ExpiringSet;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;

public class Shockwave
extends AbilityInstance {
    private static final Vector3d OFFSET = Vector3d.of(0.4, 0.85, 0.4);
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private final MultiUpdatable<Ripple> streams = MultiUpdatable.empty();
    private final Set<UUID> affectedEntities = new HashSet<UUID>();
    private final Set<Block> affectedBlocks = new HashSet<Block>();
    private final ExpiringSet<Block> recentAffectedBlocks = new ExpiringSet(500L);
    private Collection<Collider> colliders = List.of();
    private Vector3d origin;
    private boolean released;
    private double range;
    private long startTime;

    public Shockwave(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (method == Activation.ATTACK) {
            user.game().abilityManager(user.worldKey()).firstInstance(user, Shockwave.class).ifPresent(s -> s.release(true));
            return false;
        }
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, Shockwave.class)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        this.released = false;
        if (method == Activation.FALL) {
            if (user.propertyValue(EntityProperties.FALL_DISTANCE) < this.userConfig.fallThreshold || user.sneaking()) {
                return false;
            }
            if (!this.release(false)) {
                return false;
            }
        }
        this.startTime = System.currentTimeMillis();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (!this.released) {
            boolean charged = this.isCharged();
            if (charged) {
                Particle.SMOKE.builder(this.user.mainHandSide()).spawn(this.user.world());
                if (!this.user.sneaking() && !this.release(false)) {
                    return Updatable.UpdateResult.REMOVE;
                }
            } else if (!this.user.sneaking()) {
                return Updatable.UpdateResult.REMOVE;
            }
            return Updatable.UpdateResult.CONTINUE;
        }
        this.colliders = this.recentAffectedBlocks.snapshot().stream().map(b -> AABB.BLOCK_BOUNDS.grow(OFFSET).at((Position)b)).toList();
        if (!this.colliders.isEmpty()) {
            CollisionUtil.handle(this.user, Sphere.of(this.origin, this.range + 2.0), this::onEntityHit, false);
        }
        return this.streams.update();
    }

    private boolean onEntityHit(Entity entity) {
        if (!this.affectedEntities.contains(entity.uuid())) {
            Vector3d loc = entity.location();
            AABB entityCollider = entity.bounds();
            for (Collider aabb : this.colliders) {
                if (!aabb.intersects(entityCollider)) continue;
                this.affectedEntities.add(entity.uuid());
                entity.damage(this.userConfig.damage, this.user, this.description());
                double deltaY = Math.min(0.8, 0.4 + loc.distance(this.origin) / (1.5 * this.range));
                Vector3d push = (Vector3d)((Vector3d)((Vector3d)loc.subtract(this.origin)).normalize().withY(deltaY)).multiply(this.userConfig.knockback);
                entity.applyVelocity(this, push);
                return true;
            }
        }
        return false;
    }

    private boolean isCharged() {
        return System.currentTimeMillis() >= this.startTime + this.userConfig.chargeTime;
    }

    private boolean release(boolean cone) {
        if (this.released || !this.isCharged() || !this.user.isOnGround()) {
            return false;
        }
        this.released = true;
        this.range = cone ? this.userConfig.coneRange : this.userConfig.ringRange;
        this.origin = this.user.location().center();
        Vector3d dir = ((Vector3d)this.user.direction().withY(0.0)).normalize();
        if (cone) {
            double deltaAngle = Math.PI / (3.0 * this.range);
            VectorUtil.createArc(dir, Vector3d.PLUS_J, deltaAngle, FastMath.ceil(this.range / 1.5)).forEach(v -> this.streams.add(new Ripple(Ray.of(this.origin, (Vector3d)v.multiply(this.range)), 0L)));
        } else {
            VectorUtil.circle(dir, Vector3d.PLUS_J, FastMath.ceil(6.0 * this.range)).forEach(v -> this.streams.add(new Ripple(Ray.of(this.origin, (Vector3d)v.multiply(this.range)), 75L)));
        }
        if (this.streams.update() == Updatable.UpdateResult.REMOVE) {
            return false;
        }
        this.removalPolicy = Policies.defaults();
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
        return true;
    }

    @Override
    public Collection<Collider> colliders() {
        return this.colliders;
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 8000L;
        @Modifiable(value=Attribute.CHARGE_TIME)
        private long chargeTime = 2500L;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 3.0;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockback = 1.2;
        @Modifiable(value=Attribute.RANGE)
        private double coneRange = 14.0;
        @Modifiable(value=Attribute.RANGE)
        private double ringRange = 9.0;
        private double fallThreshold = 12.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "shockwave");
        }
    }

    private class Ripple
    extends BlockLine {
        public Ripple(Ray ray, long interval) {
            super(Shockwave.this.user, ray);
            this.interval = interval;
        }

        @Override
        public boolean isValidBlock(Block block) {
            if (block.type().isLiquid() || !MaterialUtil.isTransparent(block)) {
                return false;
            }
            return EarthMaterials.isEarthbendable(Shockwave.this.user, block.offset(Direction.DOWN));
        }

        @Override
        public void render(Block block) {
            if (!Shockwave.this.affectedBlocks.add(block)) {
                return;
            }
            Shockwave.this.recentAffectedBlocks.forceAdd(block);
            WorldUtil.tryBreakPlant(block);
            if (MaterialUtil.isFire(block)) {
                block.setType(BlockType.AIR);
            }
            double deltaY = Math.min(0.38, 0.18 + this.distanceTravelled / (3.0 * Shockwave.this.range));
            Block below = block.offset(Direction.DOWN);
            int blockLight = Shockwave.this.user.world().blockLightLevel(block);
            int skyLight = Shockwave.this.user.world().skyLightLevel(block);
            BlockState data = below.state();
            ((TempDisplayEntity.Builder)((TempDisplayEntity.Builder)((TempDisplayEntity.Builder)TempDisplayEntity.builder(data).gravity(true)).velocity(Vector3d.of(0.0, deltaY, 0.0))).duration(1200L)).edit(c -> c.brightness(blockLight, skyLight)).build(below);
            data.asParticle(block.center().add(0.0, deltaY, 0.0)).count(5).offset(0.5, 0.25, 0.5).spawn(Shockwave.this.user.world());
            if (ThreadLocalRandom.current().nextInt(6) == 0) {
                SoundEffect.EARTH.play(block);
            }
        }
    }
}

