/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.MultiUpdatable;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.Pillar;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Vector3d;

public class RaiseEarth
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Block origin;
    private Predicate<Block> predicate;
    private Collection<Block> raisedCache;
    private final MultiUpdatable<Pillar> pillars = MultiUpdatable.empty();
    private long interval = 100L;

    public RaiseEarth(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        boolean wall;
        this.user = user;
        this.loadConfig();
        this.predicate = b -> EarthMaterials.isEarthNotLava(user, b);
        this.origin = user.find(this.userConfig.selectRange, this.predicate);
        if (this.origin == null) {
            return false;
        }
        this.loadRaised();
        boolean bl = wall = method == Activation.SNEAK;
        if (wall) {
            this.raiseWall(this.userConfig.wallMaxHeight, this.userConfig.wallWidth);
        } else {
            this.origin.world().findTop(this.origin, this.userConfig.columnMaxHeight, this.predicate).ifPresent(b -> this.createPillar((Block)b, this.userConfig.columnMaxHeight));
        }
        if (!this.pillars.isEmpty()) {
            user.addCooldown(this.description(), wall ? this.userConfig.wallCooldown : this.userConfig.columnCooldown);
            this.removalPolicy = Policies.defaults();
            return true;
        }
        return false;
    }

    public boolean activate(User user, Block source, int height, int width, long interval) {
        this.user = user;
        this.predicate = b -> EarthMaterials.isEarthNotLava(user, b);
        this.origin = source;
        this.loadRaised();
        this.interval = interval;
        this.raiseWall(height, width);
        if (!this.pillars.isEmpty()) {
            this.removalPolicy = Policies.defaults();
            return true;
        }
        return false;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.pillars.update();
    }

    private void createPillar(Block block, int height) {
        for (Block b : new Block[]{block, block.offset(Direction.DOWN)}) {
            if (this.predicate.test(b) && TempBlock.isBendable(b) && !this.isRaised(b)) continue;
            return;
        }
        if (MaterialUtil.isTransparentOrWater(block.offset(Direction.DOWN, height))) {
            return;
        }
        Pillar.builder(this.user, block).interval(this.interval).predicate(this.predicate).build(height).ifPresent(this.pillars::add);
    }

    private void loadRaised() {
        this.raisedCache = this.user.game().abilityManager(this.user.worldKey()).instances(RaiseEarth.class).flatMap(RaiseEarth::pillars).map(Pillar::pillarBlocks).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    private boolean isRaised(Block block) {
        return this.raisedCache.contains(block);
    }

    private void raiseWall(int height, int width) {
        double w = (double)(width - 1) / 2.0;
        Vector3d side = this.user.direction().cross(Vector3d.PLUS_J).normalize();
        Vector3d center = this.origin.center();
        int min = -FastMath.ceil(w);
        int max = FastMath.floor(w);
        block0: for (int i = min; i <= max; ++i) {
            Block check = this.user.world().blockAt((Position)center.add((Position)side.multiply(i)));
            if (MaterialUtil.isTransparentOrWater(check)) {
                for (int j = 1; j < height; ++j) {
                    Block block = check.offset(Direction.DOWN, j);
                    if (this.predicate.test(block) && !this.isRaised(block)) {
                        this.createPillar(block, height);
                        continue block0;
                    }
                    if (!MaterialUtil.isTransparentOrWater(block)) continue block0;
                }
                continue;
            }
            check.world().findTop(check, height, this.predicate).ifPresent(b -> this.createPillar((Block)b, height));
        }
    }

    public Stream<Pillar> pillars() {
        return this.pillars.stream();
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.SELECTION)
        private double selectRange = 16.0;
        @Modifiable(value=Attribute.COOLDOWN)
        private long columnCooldown = 500L;
        @Modifiable(value=Attribute.HEIGHT)
        private int columnMaxHeight = 6;
        @Modifiable(value=Attribute.COOLDOWN)
        private long wallCooldown = 1500L;
        @Modifiable(value=Attribute.HEIGHT)
        private int wallMaxHeight = 6;
        @Modifiable(value=Attribute.RADIUS)
        private int wallWidth = 6;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "raiseearth");
        }
    }
}

