/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth;

import java.util.List;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.AbstractRide;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.sound.Sound;
import me.moros.bending.api.temporal.TempDisplayEntity;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.Vector3i;
import me.moros.math.VectorUtil;

public class EarthSurf
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Wave wave;
    private boolean charging;
    private long startTime;

    public EarthSurf(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, EarthSurf.class)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.charging = true;
        if (method == Activation.FALL) {
            if (user.propertyValue(EntityProperties.FALL_DISTANCE) < this.userConfig.fallThreshold || user.sneaking()) {
                return false;
            }
            return this.launch();
        }
        this.startTime = System.currentTimeMillis();
        this.removalPolicy = Policies.builder().add(Policies.UNDER_WATER).add(Policies.UNDER_LAVA).add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        return true;
    }

    private boolean launch() {
        double dist = this.user.distanceAboveGround(2.5);
        Block check = this.user.world().blockAt((Position)this.user.location().subtract(0.0, dist + 0.05, 0.0));
        if (dist > 2.25 || !EarthMaterials.isEarthOrSand(check)) {
            return false;
        }
        this.charging = false;
        this.removalPolicy = Policies.builder().add(Policies.SNEAKING).add(Policies.UNDER_WATER).add(Policies.UNDER_LAVA).add(ExpireRemovalPolicy.of(this.userConfig.duration)).add(SwappedSlotsRemovalPolicy.of(this.description())).build();
        this.wave = new Wave();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (!this.user.canBuild()) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.charging) {
            if (System.currentTimeMillis() >= this.startTime + this.userConfig.chargeTime) {
                if (this.user.sneaking()) {
                    Particle.SMOKE.builder(this.user.mainHandSide()).spawn(this.user.world());
                    return Updatable.UpdateResult.CONTINUE;
                }
                return this.launch() ? Updatable.UpdateResult.CONTINUE : Updatable.UpdateResult.REMOVE;
            }
            if (this.user.sneaking()) {
                return Updatable.UpdateResult.CONTINUE;
            }
            return Updatable.UpdateResult.REMOVE;
        }
        return this.wave.update();
    }

    @Override
    public void onDestroy() {
        if (this.wave != null) {
            this.wave.onDestroy();
            this.user.addCooldown(this.description(), this.userConfig.cooldown);
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.SPEED)
        private double speed = 0.5;
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 6000L;
        @Modifiable(value=Attribute.CHARGE_TIME)
        private long chargeTime = 1500L;
        @Modifiable(value=Attribute.DURATION)
        private long duration = 0L;
        private double fallThreshold = 12.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "earthsurf");
        }
    }

    private final class Wave
    extends AbstractRide {
        private Vector3d center;
        private int ticks;

        private Wave() {
            super(EarthSurf.this.user, EarthSurf.this.userConfig.speed, 2.25);
            this.ticks = 0;
            this.predicate = EarthMaterials::isEarthOrSand;
        }

        @Override
        public void render(BlockState data) {
            if (this.ticks % 3 == 0) {
                return;
            }
            Vector3i lightLoc = ((Vector3d)EarthSurf.this.user.location().add(Vector3i.MINUS_J)).toVector3i();
            int blockLight = EarthSurf.this.user.world().blockLightLevel(lightLoc);
            int skyLight = EarthSurf.this.user.world().skyLightLevel(lightLoc);
            TempDisplayEntity.Builder builder = (TempDisplayEntity.Builder)((TempDisplayEntity.Builder)((TempDisplayEntity.Builder)TempDisplayEntity.builder(data).gravity(true)).velocity(Vector3d.of(0.0, 0.25, 0.0))).edit(c -> c.brightness(blockLight, skyLight)).minYOffset(-1.25).duration(750L);
            Vector3d center = (Vector3d)EarthSurf.this.user.location().add(Vector3d.MINUS_J);
            Vector3d dir = ((Vector3d)EarthSurf.this.user.direction().withY(0.0)).normalize(((Vector3d)EarthSurf.this.user.velocity().withY(0.0)).normalize());
            VectorUtil.createArc(dir, Vector3d.PLUS_J, 1.0471975511965976, 3).forEach(v -> builder.build(EarthSurf.this.user.world(), (Vector3d)center.add((Position)v.multiply(0.6))));
        }

        @Override
        public void postRender() {
            this.center = (Vector3d)EarthSurf.this.user.location().subtract(0.0, 0.5, 0.0);
            if (++this.ticks % 4 == 0) {
                Sound.BLOCK_ROOTED_DIRT_FALL.asEffect(0.6f, 0.0f).play(EarthSurf.this.user.world(), this.center);
            }
            CollisionUtil.handle(EarthSurf.this.user, Sphere.of(this.center, 1.2), this::onEntityHit, false);
        }

        @Override
        protected void affect(Vector3d velocity) {
            EarthSurf.this.user.applyVelocity(EarthSurf.this, velocity);
        }

        private boolean onEntityHit(Entity entity) {
            Vector3d velocity = ((Vector3d)((Vector3d)entity.center().subtract(this.center)).withY(0.35)).normalize();
            entity.applyVelocity(EarthSurf.this, velocity);
            return false;
        }
    }
}

