/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.collision.Collision;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityUtil;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.potion.PotionEffect;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.temporal.TempEntity;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.api.util.material.WaterMaterials;
import me.moros.bending.common.ability.earth.LavaDisk;
import me.moros.bending.common.ability.earth.util.Boulder;
import me.moros.bending.common.ability.fire.FlameRush;
import me.moros.bending.common.ability.water.FrostBreath;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;
import org.jspecify.annotations.Nullable;

public class EarthSmash
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private RemovalPolicy swappedSlotsPolicy;
    private EarthSmashState state;
    private Boulder boulder;

    public EarthSmash(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        Optional<EarthSmash> grabbed = user.game().abilityManager(user.worldKey()).userInstances(user, EarthSmash.class).filter(s -> s.state instanceof GrabState).findAny();
        if (method == Activation.SNEAK) {
            if (grabbed.isPresent() || EarthSmash.tryGrab(user, this.userConfig)) {
                return false;
            }
        } else if (method == Activation.ATTACK) {
            grabbed.ifPresent(EarthSmash::launchBoulder);
            return false;
        }
        if (user.onCooldown(this.description())) {
            return false;
        }
        this.state = new ChargeState();
        this.removalPolicy = Policies.defaults();
        this.swappedSlotsPolicy = SwappedSlotsRemovalPolicy.of(this.description());
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (!this.state.canSlotSwitch() && this.swappedSlotsPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.boulder != null && this.boulder.isEmpty()) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.state.update();
    }

    private boolean createBoulder() {
        Block center = this.user.find(this.userConfig.selectRange, b -> EarthMaterials.isEarthNotLava(this.user, b));
        if (center == null) {
            return false;
        }
        int radius = Math.max(3, this.userConfig.radius);
        if (radius % 2 == 0) {
            ++radius;
        }
        for (int i = 0; i <= radius; ++i) {
            Block b2 = center.offset(Direction.UP, i + 1);
            if (MaterialUtil.isTransparent(b2) && TempBlock.isBendable(b2) && this.user.canBuild(b2)) continue;
            return false;
        }
        this.boulder = new Boulder(this.user, center, radius, this.userConfig.maxDuration);
        int minRequired = FastMath.ceil(Math.pow(radius, 3.0) * 0.375);
        if (this.boulder.dataSize() < minRequired) {
            this.boulder = null;
            return false;
        }
        this.state = new LiftState();
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
        return true;
    }

    private void launchBoulder() {
        this.state = new ShotState();
    }

    private void grabBoulder() {
        this.state = new GrabState();
    }

    private static boolean tryGrab(User user, Config config) {
        Block target = user.rayTrace(config.grabRange).blocks(user.world()).block();
        EarthSmash earthSmash = EarthSmash.getInstance(user, target, s -> s.state.canGrab());
        if (earthSmash == null) {
            return false;
        }
        user.game().abilityManager(user.worldKey()).changeOwner(earthSmash, user);
        earthSmash.grabBoulder();
        return true;
    }

    public static void tryDestroy(User user, Block block) {
        EarthSmash earthSmash;
        if (user.sneaking() && user.hasAbilitySelected("earthsmash") && (earthSmash = EarthSmash.getInstance(user, block, x -> true)) != null) {
            earthSmash.shatter();
        }
    }

    private static @Nullable EarthSmash getInstance(User user, @Nullable Block block, Predicate<EarthSmash> filter) {
        if (block == null) {
            return null;
        }
        AABB blockBounds = AABB.BLOCK_BOUNDS.at(block);
        return user.game().abilityManager(user.worldKey()).instances(EarthSmash.class).filter(filter).filter(s -> s.boulder != null && s.boulder.preciseBounds().at(s.boulder.center()).intersects(blockBounds)).findAny().orElse(null);
    }

    private void cleanAll() {
        for (Map.Entry<Block, BlockState> entry : this.boulder.data().entrySet()) {
            Block block = entry.getKey();
            if (block.type() != entry.getValue().type()) continue;
            TempBlock.air().build(block);
        }
    }

    private void render() {
        for (Map.Entry<Block, BlockState> entry : this.boulder.data().entrySet()) {
            Block block = entry.getKey();
            if (!MaterialUtil.isTransparent(block)) continue;
            WorldUtil.tryBreakPlant(block);
            TempBlock.builder(entry.getValue()).build(block);
        }
    }

    private void shatter() {
        if (this.boulder != null && !this.boulder.isEmpty()) {
            HashMap<TempEntity.TempFallingBlock, ShardType> shards = new HashMap<TempEntity.TempFallingBlock, ShardType>();
            for (Map.Entry<Block, BlockState> entry : this.boulder.data().entrySet()) {
                Vector3d velocity = VectorUtil.gaussianOffset(Vector3d.ZERO, 0.2, 0.1, 0.2);
                Block block = entry.getKey();
                BlockState blockData = entry.getValue();
                TempBlock.air().build(block);
                TempEntity.TempFallingBlock projectile = ((TempEntity.FallingBlockBuilder)((TempEntity.FallingBlockBuilder)TempEntity.fallingBlock(blockData).velocity(velocity)).duration(5000L)).buildReal(block);
                shards.put(projectile, ShardType.from(blockData.type()));
                blockData.asParticle(block.center()).count(4).offset(0.5).spawn(block.world());
                if (!ThreadLocalRandom.current().nextBoolean()) continue;
                blockData.type().soundGroup().breakSound().asEffect().play(block);
            }
            this.boulder.clearData();
            if (this.userConfig.shatterEffects) {
                this.boulder = null;
                this.state = new ShatteredState(shards);
            }
        }
    }

    @Override
    public void onDestroy() {
        if (this.boulder != null) {
            this.cleanAll();
        }
    }

    @Override
    public void onUserChange(User newUser) {
        this.user = newUser;
        this.boulder.user(newUser);
    }

    @Override
    public Collection<Collider> colliders() {
        return !this.state.canCollide() ? List.of() : List.of(this.boulder.collider());
    }

    @Override
    public void onCollision(Collision collision) {
        FlameRush other;
        if (this.boulder == null) {
            return;
        }
        Ability collidedAbility = collision.collidedAbility();
        boolean shatter = collision.removeSelf();
        if (collidedAbility instanceof FlameRush && (other = (FlameRush)collidedAbility).isFullyCharged()) {
            shatter = true;
        } else if (collidedAbility instanceof FrostBreath) {
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            this.boulder.updateData((k, v) -> rand.nextBoolean() ? BlockType.ICE.defaultState() : BlockType.PACKED_ICE.defaultState());
            shatter = true;
        }
        if (shatter) {
            if (collidedAbility.description().elements().contains((Object)Element.FIRE) || collidedAbility instanceof LavaDisk) {
                this.boulder.updateData((k, v) -> BlockType.MAGMA_BLOCK.defaultState());
            }
            collision.removeSelf(false);
            this.shatter();
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 7000L;
        @Modifiable(value=Attribute.RADIUS)
        private int radius = 3;
        @Modifiable(value=Attribute.CHARGE_TIME)
        private long chargeTime = 1250L;
        @Modifiable(value=Attribute.SELECTION)
        private double selectRange = 10.0;
        @Modifiable(value=Attribute.DURATION)
        private long maxDuration = 45000L;
        @Modifiable(value=Attribute.STRENGTH)
        private double raiseEntityPush = 0.85;
        @Modifiable(value=Attribute.SELECTION)
        private double grabRange = 10.0;
        @Modifiable(value=Attribute.RANGE)
        private double shootRange = 16.0;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 3.5;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockback = 2.8;
        @Modifiable(value=Attribute.STRENGTH)
        private double knockup = 0.15;
        private boolean shatterEffects = true;
        @Modifiable(value=Attribute.DAMAGE)
        private double shatterDamage = 1.0;
        @Modifiable(value=Attribute.FIRE_TICKS)
        private int fireTicks = 25;
        @Modifiable(value=Attribute.FREEZE_TICKS)
        private int freezeTicks = 60;
        @Modifiable(value=Attribute.STRENGTH)
        private int mudPower = 2;
        @Modifiable(value=Attribute.DURATION)
        private long mudDuration = 1500L;
        @Modifiable(value=Attribute.STRENGTH)
        private int sandPower = 2;
        @Modifiable(value=Attribute.DURATION)
        private long sandDuration = 1500L;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "earthsmash");
        }
    }

    private final class ChargeState
    implements EarthSmashState {
        private final long startTime = System.currentTimeMillis();

        private ChargeState() {
        }

        @Override
        public Updatable.UpdateResult update() {
            if (System.currentTimeMillis() >= this.startTime + EarthSmash.this.userConfig.chargeTime) {
                if (EarthSmash.this.user.sneaking()) {
                    Particle.SMOKE.builder(EarthSmash.this.user.mainHandSide()).spawn(EarthSmash.this.user.world());
                    return Updatable.UpdateResult.CONTINUE;
                }
                return EarthSmash.this.createBoulder() ? Updatable.UpdateResult.CONTINUE : Updatable.UpdateResult.REMOVE;
            }
            if (EarthSmash.this.user.sneaking()) {
                return Updatable.UpdateResult.CONTINUE;
            }
            return Updatable.UpdateResult.REMOVE;
        }

        @Override
        public boolean canCollide() {
            return false;
        }

        @Override
        public boolean canSlotSwitch() {
            return false;
        }
    }

    private static interface EarthSmashState
    extends Updatable {
        default public boolean canGrab() {
            return false;
        }

        default public boolean canCollide() {
            return true;
        }

        default public boolean canSlotSwitch() {
            return true;
        }
    }

    private final class LiftState
    implements EarthSmashState {
        private final Vector3d origin;
        private int tick = 0;
        private long nextLiftTime = 0L;

        private LiftState() {
            this.origin = EarthSmash.this.boulder.center();
        }

        @Override
        public Updatable.UpdateResult update() {
            AABB liftCollider = EarthSmash.this.boulder.bounds().at((Position)EarthSmash.this.boulder.center().add(Vector3d.PLUS_J));
            CollisionUtil.handle(EarthSmash.this.user, liftCollider, entity -> {
                Vector3d push = (Vector3d)entity.velocity().withY(EarthSmash.this.userConfig.raiseEntityPush);
                return entity.applyVelocity(EarthSmash.this, push);
            }, true, true);
            long time = System.currentTimeMillis();
            if (time < this.nextLiftTime) {
                return Updatable.UpdateResult.CONTINUE;
            }
            this.nextLiftTime = time + 70L;
            EarthSmash.this.cleanAll();
            EarthSmash.this.boulder.center((Position)EarthSmash.this.boulder.center().add(Vector3d.PLUS_J));
            SoundEffect.EARTH.play(EarthSmash.this.boulder.world(), EarthSmash.this.boulder.center());
            EarthSmash.this.render();
            this.clearSourceArea();
            return Updatable.UpdateResult.CONTINUE;
        }

        private void clearSourceArea() {
            ++this.tick;
            int half = (EarthSmash.this.boulder.size() - 1) / 2;
            if (this.tick >= EarthSmash.this.boulder.size()) {
                EarthSmash.this.state = new IdleState();
            } else if (this.tick == half) {
                Block originBlock = EarthSmash.this.boulder.world().blockAt(this.origin);
                for (int z = -half; z <= half; ++z) {
                    for (int x = -half; x <= half; ++x) {
                        Block block;
                        if ((Math.abs(x) + Math.abs(z)) % 2 != 0) {
                            block = originBlock.offset(x, -1, z);
                            if (EarthMaterials.isEarthNotLava(EarthSmash.this.user, block)) {
                                TempBlock.air().duration(BendingProperties.instance().earthRevertTime()).build(block);
                            }
                        }
                        block = originBlock.offset(x, 0, z);
                        if (!EarthMaterials.isEarthNotLava(EarthSmash.this.user, block)) continue;
                        TempBlock.air().duration(BendingProperties.instance().earthRevertTime()).build(block);
                    }
                }
            }
        }
    }

    private final class ShotState
    implements EarthSmashState {
        private final Set<UUID> affectedEntities = new HashSet<UUID>();
        private final Vector3d origin;
        private final Vector3d direction;
        private Vector3d location;
        private int buffer;
        private final int speed = 18;

        private ShotState() {
            this.location = this.origin = EarthSmash.this.boulder.center();
            this.direction = EarthSmash.this.user.direction();
            SoundEffect.EARTH.play(EarthSmash.this.boulder.world(), EarthSmash.this.boulder.center());
            this.buffer = 18;
        }

        @Override
        public Updatable.UpdateResult update() {
            this.buffer += 18;
            if (this.buffer < 20) {
                return Updatable.UpdateResult.CONTINUE;
            }
            this.buffer -= 20;
            CollisionUtil.handle(EarthSmash.this.user, EarthSmash.this.boulder.collider(), this::onEntityHit);
            EarthSmash.this.cleanAll();
            this.location = (Vector3d)this.location.add(this.direction);
            Block newCenter = EarthSmash.this.boulder.world().blockAt(this.location);
            if (!EarthSmash.this.boulder.isValidBlock(newCenter)) {
                EarthSmash.this.shatter();
                return Updatable.UpdateResult.CONTINUE;
            }
            EarthSmash.this.boulder.center(newCenter);
            if (this.origin.distanceSq(EarthSmash.this.boulder.center()) > EarthSmash.this.userConfig.shootRange * EarthSmash.this.userConfig.shootRange) {
                return Updatable.UpdateResult.REMOVE;
            }
            if (!EarthSmash.this.boulder.blendSmash(this.direction)) {
                EarthSmash.this.shatter();
                return Updatable.UpdateResult.CONTINUE;
            }
            EarthSmash.this.render();
            return Updatable.UpdateResult.CONTINUE;
        }

        private boolean onEntityHit(Entity entity) {
            if (this.affectedEntities.add(entity.uuid())) {
                entity.damage(EarthSmash.this.userConfig.damage, EarthSmash.this.user, EarthSmash.this.description());
                Vector3d velocity = ((Vector3d)((Vector3d)entity.center().subtract(EarthSmash.this.boulder.center())).withY(EarthSmash.this.userConfig.knockup)).normalize();
                entity.applyVelocity(EarthSmash.this, (Vector3d)velocity.multiply(EarthSmash.this.userConfig.knockback));
                return true;
            }
            return false;
        }

        @Override
        public boolean canGrab() {
            return true;
        }
    }

    private final class GrabState
    implements EarthSmashState {
        private final double grabbedDistance;

        private GrabState() {
            this.grabbedDistance = Math.min(EarthSmash.this.boulder.center().distance(EarthSmash.this.user.eyeLocation()), EarthSmash.this.userConfig.grabRange);
        }

        @Override
        public Updatable.UpdateResult update() {
            if (EarthSmash.this.user.sneaking()) {
                Vector3d dir = (Vector3d)EarthSmash.this.user.direction().normalize().multiply(this.grabbedDistance);
                Block newCenter = EarthSmash.this.boulder.world().blockAt((Position)EarthSmash.this.user.eyeLocation().add(dir));
                if (newCenter.equals(EarthSmash.this.boulder.world().blockAt(EarthSmash.this.boulder.center()))) {
                    return Updatable.UpdateResult.CONTINUE;
                }
                EarthSmash.this.boulder.updateData();
                EarthSmash.this.cleanAll();
                if (EarthSmash.this.boulder.isValidCenter(newCenter)) {
                    EarthSmash.this.boulder.center(newCenter);
                }
                EarthSmash.this.render();
            } else {
                EarthSmash.this.state = new IdleState();
            }
            return Updatable.UpdateResult.CONTINUE;
        }

        @Override
        public boolean canSlotSwitch() {
            return false;
        }
    }

    private static enum ShardType {
        MAGMA,
        SAND,
        ICE,
        MUD,
        ROCK;


        private static ShardType from(BlockType material) {
            if (EarthMaterials.LAVA_BENDABLE.isTagged(material)) {
                return MAGMA;
            }
            if (EarthMaterials.SAND_BENDABLE.isTagged(material)) {
                return SAND;
            }
            if (WaterMaterials.ICE_BENDABLE.isTagged(material)) {
                return ICE;
            }
            if (EarthMaterials.MUD_BENDABLE.isTagged(material)) {
                return MUD;
            }
            return ROCK;
        }
    }

    private final class ShatteredState
    implements EarthSmashState {
        private final Map<TempEntity.TempFallingBlock, ShardType> pieces;
        private final Set<UUID> affectedEntities;

        private ShatteredState(Map<TempEntity.TempFallingBlock, ShardType> pieces) {
            this.pieces = pieces;
            this.affectedEntities = new HashSet<UUID>();
        }

        @Override
        public Updatable.UpdateResult update() {
            this.pieces.entrySet().removeIf(this::tryCollisions);
            return this.pieces.isEmpty() ? Updatable.UpdateResult.REMOVE : Updatable.UpdateResult.CONTINUE;
        }

        private boolean tryCollisions(Map.Entry<TempEntity.TempFallingBlock, ShardType> entry) {
            TempEntity.TempFallingBlock fb = entry.getKey();
            return !fb.valid() || CollisionUtil.handle(EarthSmash.this.user, AABB.BLOCK_BOUNDS.at(fb.center()), e -> this.onEntityHit(e, (ShardType)((Object)((Object)entry.getValue()))));
        }

        private boolean onEntityHit(Entity entity, ShardType type) {
            if (this.affectedEntities.add(entity.uuid())) {
                switch (type.ordinal()) {
                    case 0: {
                        BendingEffect.FIRE_TICK.apply(EarthSmash.this.user, entity, EarthSmash.this.userConfig.fireTicks);
                        break;
                    }
                    case 1: {
                        EntityUtil.tryAddPotion(entity, PotionEffect.BLINDNESS, FastMath.round((double)EarthSmash.this.userConfig.sandDuration / 50.0), EarthSmash.this.userConfig.sandPower - 1);
                        break;
                    }
                    case 2: {
                        BendingEffect.FROST_TICK.apply(EarthSmash.this.user, entity, EarthSmash.this.userConfig.freezeTicks);
                        break;
                    }
                    case 3: {
                        EntityUtil.tryAddPotion(entity, PotionEffect.SLOWNESS, FastMath.round((double)EarthSmash.this.userConfig.mudDuration / 50.0), EarthSmash.this.userConfig.mudPower - 1);
                    }
                }
                entity.damage(EarthSmash.this.userConfig.shatterDamage, EarthSmash.this.user, EarthSmash.this.description());
                return true;
            }
            return false;
        }

        @Override
        public boolean canCollide() {
            return false;
        }
    }

    private class IdleState
    implements EarthSmashState {
        private IdleState() {
        }

        @Override
        public Updatable.UpdateResult update() {
            return System.currentTimeMillis() > EarthSmash.this.boulder.expireTime() ? Updatable.UpdateResult.REMOVE : Updatable.UpdateResult.CONTINUE;
        }

        @Override
        public boolean canGrab() {
            return true;
        }
    }
}

