/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Explosive;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.FragileStructure;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.collision.raytrace.Context;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.temporal.TempEntity;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingExplosion;
import me.moros.bending.api.util.FeaturePermissions;
import me.moros.bending.api.util.functional.OutOfRangeRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import org.jspecify.annotations.Nullable;

public class EarthShot
extends AbilityInstance
implements Explosive {
    private static final AABB BOX = AABB.BLOCK_BOUNDS.grow(Vector3d.of(0.25, 0.25, 0.25));
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Mode mode;
    private Block source;
    private Block readySource;
    private BlockState data;
    private Vector3d location;
    private Vector3d lastVelocity;
    private TempEntity.TempFallingBlock projectile;
    private boolean ready = false;
    private boolean launched = false;
    private boolean canConvert = false;
    private boolean exploded = false;
    private double damage;
    private int targetY;
    private long magmaStartTime = 0L;

    public EarthShot(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (method == Activation.ATTACK) {
            user.game().abilityManager(user.worldKey()).userInstances(user, EarthShot.class).filter(e -> !e.launched).forEach(EarthShot::launch);
            return false;
        }
        this.user = user;
        this.loadConfig();
        long count = user.game().abilityManager(user.worldKey()).userInstances(user, EarthShot.class).filter(e -> !e.launched).count();
        if (count >= (long)this.userConfig.maxAmount) {
            return false;
        }
        this.canConvert = this.userConfig.allowConvertMagma && user.hasPermission(FeaturePermissions.LAVA);
        return this.prepare();
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    private boolean prepare() {
        BlockState solidData;
        this.source = this.user.find(this.userConfig.selectRange, b -> EarthMaterials.isEarthbendable(this.user, b));
        if (this.source == null) {
            return false;
        }
        this.mode = this.getType(this.source);
        this.targetY = this.source.blockY() < this.user.eyeBlock().blockY() ? this.user.eyeBlock().blockY() + 1 : this.source.blockY() + 2;
        int deltaY = Math.abs(this.source.blockY() - this.targetY);
        for (int i = 1; i <= deltaY; ++i) {
            Block temp = this.source.offset(Direction.UP, i);
            if (!MaterialUtil.isTransparent(temp)) {
                return false;
            }
            WorldUtil.tryBreakPlant(temp);
        }
        this.data = this.source.state();
        if (this.mode == Mode.MAGMA) {
            solidData = BlockType.MAGMA_BLOCK.defaultState();
            this.canConvert = false;
        } else {
            solidData = MaterialUtil.solidType(this.data.type()).defaultState();
        }
        if (this.mode == Mode.METAL) {
            SoundEffect.METAL.play(this.source);
            this.canConvert = false;
        } else {
            SoundEffect.EARTH.play(this.source);
        }
        if (!MaterialUtil.isLava(this.source)) {
            TempBlock.air().duration(BendingProperties.instance().earthRevertTime()).build(this.source);
        }
        this.projectile = ((TempEntity.FallingBlockBuilder)((TempEntity.FallingBlockBuilder)TempEntity.fallingBlock(solidData).velocity(Vector3d.of(0.0, 0.65, 0.0))).gravity(false)).buildReal(this.source);
        this.location = this.projectile.center();
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).add(OutOfRangeRemovalPolicy.of(this.userConfig.selectRange + 10.0, () -> this.location)).build();
        return true;
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.exploded || this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.launched) {
            boolean magma;
            if (!this.projectile.valid()) {
                return Updatable.UpdateResult.REMOVE;
            }
            Vector3d velocity = this.projectile.velocity();
            double minLength = this.userConfig.speed * 0.85;
            if (this.lastVelocity.angle(velocity) > 0.7853981633974483 || velocity.lengthSq() < minLength * minLength) {
                return Updatable.UpdateResult.REMOVE;
            }
            if (this.user.sneaking()) {
                Vector3d dir = (Vector3d)this.user.direction().multiply(0.2);
                velocity = (Vector3d)velocity.add((Position)dir.withY(0.0));
            }
            this.projectile.applyVelocity(this, (Vector3d)velocity.normalize().multiply(this.userConfig.speed));
            this.lastVelocity = this.projectile.velocity();
            this.location = this.projectile.center();
            AABB c = BOX.at(this.location);
            boolean bl = magma = this.mode == Mode.MAGMA;
            if (CollisionUtil.handle(this.user, c, this::onEntityHit, true, false, magma)) {
                return Updatable.UpdateResult.REMOVE;
            }
            this.projectile.state().asParticle(this.projectile.location()).count(3).offset(0.25).spawn(this.user.world());
        } else if (!this.ready) {
            this.handleSource();
        } else {
            this.handleMagma();
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    private boolean onEntityHit(Entity entity) {
        if (this.mode == Mode.MAGMA) {
            this.explode();
            return false;
        }
        entity.damage(this.damage, this.user, this.description());
        Vector3d velocity = (Vector3d)this.projectile.velocity().normalize().multiply(0.4);
        entity.applyVelocity(this, velocity);
        return true;
    }

    private void handleSource() {
        Block block = this.projectile.block();
        if (block.blockY() >= this.targetY) {
            TempBlock.builder(this.projectile.state()).build(block);
            this.projectile.revert();
            this.location = block.toVector3d();
            this.readySource = block;
            this.ready = true;
        } else {
            this.location = this.projectile.center();
            this.projectile.state().asParticle(this.projectile.location()).count(3).offset(0.25).spawn(this.user.world());
        }
    }

    private void handleMagma() {
        if (!this.canConvert) {
            return;
        }
        Block check = this.user.rayTrace(this.userConfig.selectRange * 2.0).ignoreLiquids(false).blocks(this.user.world()).block();
        if (this.user.sneaking() && this.readySource.equals(check)) {
            if (this.magmaStartTime == 0L) {
                this.magmaStartTime = System.currentTimeMillis();
                if (this.userConfig.chargeTime > 0L) {
                    SoundEffect.LAVA.play(this.readySource);
                }
            }
            Vector3d spawnLoc = this.readySource.center();
            Particle.LAVA.builder(spawnLoc).count(2).offset(0.5).spawn(this.user.world());
            Particle.SMOKE.builder(spawnLoc).count(2).offset(0.5).spawn(this.user.world());
            ParticleBuilder.rgb((Position)spawnLoc, "#FFA400").count(2).offset(0.5).spawn(this.user.world());
            ParticleBuilder.rgb((Position)spawnLoc, "#FF8C00").count(4).offset(0.5).spawn(this.user.world());
            if (this.userConfig.chargeTime <= 0L || System.currentTimeMillis() > this.magmaStartTime + this.userConfig.chargeTime) {
                this.mode = Mode.MAGMA;
                TempBlock.builder(BlockType.MAGMA_BLOCK).build(this.readySource);
                this.canConvert = false;
            }
        } else {
            if (this.magmaStartTime != 0L && ThreadLocalRandom.current().nextInt(6) == 0) {
                this.removalPolicy = (u, d) -> true;
                return;
            }
            this.magmaStartTime = 0L;
        }
    }

    private Mode getType(Block block) {
        if (EarthMaterials.isLavaBendable(block)) {
            return Mode.MAGMA;
        }
        if (EarthMaterials.isMetalBendable(block)) {
            return Mode.METAL;
        }
        return Mode.ROCK;
    }

    private void launch() {
        Vector3d origin;
        if (this.launched) {
            return;
        }
        boolean prematureLaunch = false;
        if (!this.ready) {
            if (!this.userConfig.allowQuickLaunch) {
                return;
            }
            prematureLaunch = true;
        }
        if (prematureLaunch) {
            origin = this.projectile.center();
            Vector3d dir = (Vector3d)((Vector3d)this.getTarget(null).subtract(origin)).normalize().multiply(this.userConfig.speed);
            this.projectile.setProperty(EntityProperties.GRAVITY, true);
            this.projectile.applyVelocity(this, dir.add(0.0, 0.2, 0.0));
        } else {
            origin = this.readySource.center();
            Vector3d dir = ((Vector3d)((Vector3d)this.getTarget(this.readySource).subtract(origin)).normalize().multiply(this.userConfig.speed)).add(0.0, 0.2, 0.0);
            BlockState state = this.readySource.state();
            TempBlock.air().build(this.readySource);
            this.projectile = ((TempEntity.FallingBlockBuilder)TempEntity.TempFallingBlock.fallingBlock(state).velocity(dir)).buildReal(this.readySource);
        }
        this.location = this.projectile.center();
        this.lastVelocity = this.projectile.velocity();
        this.removalPolicy = Policies.builder().add(OutOfRangeRemovalPolicy.of(this.userConfig.range, origin, () -> this.location)).build();
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
        this.damage = switch (this.mode.ordinal()) {
            case 1 -> BendingProperties.instance().metalModifier(this.userConfig.damage);
            case 2 -> BendingProperties.instance().magmaModifier(this.userConfig.damage);
            default -> this.userConfig.damage;
        };
        this.launched = true;
    }

    private Vector3d getTarget(@Nullable Block source) {
        return this.user.rayTrace(this.userConfig.range).ignore(source).cast(this.user.world()).entityCenterOrPosition();
    }

    @Override
    public void explode() {
        if (this.exploded || this.mode != Mode.MAGMA) {
            return;
        }
        this.exploded = true;
        Vector3d center = this.projectile.center();
        Particle.SMOKE.builder(center).count(12).offset(1.0).extra(0.05).spawn(this.user.world());
        Particle.FIREWORK.builder(center).count(8).offset(1.0).extra(0.07).spawn(this.user.world());
        BendingExplosion.builder().size(this.userConfig.explosionRadius).damage(this.damage).fireTicks(0).particles(false).sound(SoundEffect.EXPLOSION).buildAndExplode(this, center);
    }

    @Override
    public void onDestroy() {
        if (this.projectile != null) {
            if (this.launched) {
                Vector3d center = this.projectile.center();
                this.projectile.state().asParticle(center).count(8).offset(1.0).spawn(this.user.world());
                Block projected = Context.builder(center, this.lastVelocity).blocks(this.user.world()).block();
                if (projected != null) {
                    FragileStructure.tryDamageStructure(projected, this.mode == Mode.MAGMA ? 6 : 4, Ray.of(center, this.lastVelocity));
                }
                this.explode();
            }
            this.projectile.revert();
        }
        if (!this.launched) {
            TempBlock.builder(this.data).bendable(true).duration(BendingProperties.instance().earthRevertTime()).build(this.source);
            if (this.readySource != null) {
                TempBlock.air().build(this.readySource);
            }
        }
    }

    @Override
    public Collection<Collider> colliders() {
        return !this.launched || this.projectile == null ? List.of() : List.of(BOX.at(this.projectile.center()));
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 2000L;
        @Modifiable(value=Attribute.SELECTION)
        private double selectRange = 6.0;
        @Modifiable(value=Attribute.RANGE)
        private double range = 48.0;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 3.0;
        @Modifiable(value=Attribute.CHARGE_TIME)
        private long chargeTime = 1000L;
        @Modifiable(value=Attribute.SPEED)
        private double speed = 1.6;
        @Modifiable(value=Attribute.AMOUNT)
        private int maxAmount = 1;
        private boolean allowQuickLaunch = true;
        private boolean allowConvertMagma = true;
        @Modifiable(value=Attribute.RADIUS)
        private double explosionRadius = 2.5;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "earthshot");
        }
    }

    private static enum Mode {
        ROCK,
        METAL,
        MAGMA;

    }
}

