/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth;

import java.util.Collection;
import java.util.List;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Platform;
import me.moros.bending.api.platform.block.BlockType;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.platform.entity.EntityType;
import me.moros.bending.api.platform.entity.LivingEntity;
import me.moros.bending.api.platform.item.Inventory;
import me.moros.bending.api.platform.item.Item;
import me.moros.bending.api.platform.item.ItemSnapshot;
import me.moros.bending.api.platform.item.PlayerInventory;
import me.moros.bending.api.platform.sound.Sound;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.FeaturePermissions;
import me.moros.bending.api.util.KeyUtil;
import me.moros.bending.api.util.data.DataKey;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.OutOfRangeRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import org.spongepowered.configurate.objectmapping.meta.Comment;

public class EarthGlove
extends AbilityInstance {
    public static final DataKey<EarthGlove> GLOVE_KEY = KeyUtil.data("earth-glove", EarthGlove.class);
    private static final DataKey<Side> KEY = KeyUtil.data("glove-side", Side.class);
    private static final double GLOVE_SPEED = 1.2;
    private static final double GLOVE_GRABBED_SPEED = 0.6;
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Entity glove;
    private Vector3d location;
    private Vector3d lastVelocity;
    private LivingEntity grabbedTarget;
    private boolean isMetal = false;
    private boolean returning = false;
    private boolean grabbed = false;

    public EarthGlove(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (method == Activation.SNEAK) {
            EarthGlove.tryDestroy(user);
            return false;
        }
        if (user.onCooldown(this.description()) || user.game().abilityManager(user.worldKey()).userInstances(user, EarthGlove.class).count() >= 2L) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        if (this.launchEarthGlove()) {
            this.removalPolicy = Policies.builder().add(Policies.UNDER_WATER).add(Policies.UNDER_LAVA).add(SwappedSlotsRemovalPolicy.of(this.description())).add(OutOfRangeRemovalPolicy.of(this.userConfig.range + 5.0, () -> this.location)).build();
            user.addCooldown(this.description(), this.userConfig.cooldown);
            return true;
        }
        return false;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        double factor;
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (this.glove == null || !this.glove.valid()) {
            return Updatable.UpdateResult.REMOVE;
        }
        this.location = this.glove.location();
        if (this.location.distanceSq(this.user.eyeLocation()) > this.userConfig.range * this.userConfig.range) {
            this.returning = true;
        }
        if (!this.user.canBuild(this.glove.block())) {
            this.shatterGlove();
            return Updatable.UpdateResult.REMOVE;
        }
        double d = factor = this.isMetal ? BendingProperties.instance().metalModifier() : 1.0;
        if (this.returning) {
            if (!this.user.sneaking()) {
                this.shatterGlove();
                return Updatable.UpdateResult.REMOVE;
            }
            Vector3d returnLocation = (Vector3d)this.user.eyeLocation().add((Position)this.user.direction().multiply(this.isMetal ? 5.0 : 1.5));
            if (this.location.distanceSq(returnLocation) < 1.0) {
                if (this.grabbed && this.grabbedTarget != null) {
                    this.grabbedTarget.applyVelocity(this, Vector3d.ZERO);
                }
                return Updatable.UpdateResult.REMOVE;
            }
            if (this.grabbed) {
                if (!this.isValidTarget()) {
                    this.shatterGlove();
                    return Updatable.UpdateResult.REMOVE;
                }
                Vector3d dir = (Vector3d)((Vector3d)returnLocation.subtract(this.grabbedTarget.location())).normalize().multiply(0.6);
                this.grabbedTarget.applyVelocity(this, dir);
                this.glove.teleport((Position)this.grabbedTarget.eyeLocation().subtract(0.0, this.grabbedTarget.height() / 2.0, 0.0));
                return Updatable.UpdateResult.CONTINUE;
            }
            Vector3d dir = (Vector3d)((Vector3d)returnLocation.subtract(this.location)).normalize().multiply(1.2 * factor);
            this.updateGloveVelocity(dir);
        } else {
            double velocityLimit = (this.grabbed ? 0.6 : 1.2 * factor) - 0.2;
            Vector3d gloveVelocity = this.glove.velocity();
            boolean onGround = this.glove.isOnGround();
            if (onGround || this.lastVelocity.angle(gloveVelocity) > 0.5235987755982988 || gloveVelocity.lengthSq() < velocityLimit * velocityLimit) {
                if (onGround) {
                    this.glove.velocity(Vector3d.ZERO);
                }
                this.shatterGlove();
                return Updatable.UpdateResult.REMOVE;
            }
            this.updateGloveVelocity((Vector3d)this.lastVelocity.normalize().multiply(1.2 * factor));
            boolean sneaking = this.user.sneaking();
            boolean collided = CollisionUtil.handle(this.user, Sphere.of(this.location, 0.8), this::onEntityHit, true, false, sneaking);
            if (collided && !this.grabbed) {
                return Updatable.UpdateResult.REMOVE;
            }
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    private boolean isValidTarget() {
        if (this.grabbedTarget == null || !this.grabbedTarget.valid()) {
            return false;
        }
        return this.grabbedTarget.world().equals(this.user.world());
    }

    private boolean onEntityHit(Entity entity) {
        if (this.user.sneaking()) {
            return this.grabTarget((LivingEntity)entity);
        }
        double damage = this.isMetal ? BendingProperties.instance().metalModifier(this.userConfig.damage) : this.userConfig.damage;
        entity.damage(damage, this.user, this.description());
        this.shatterGlove();
        return false;
    }

    private boolean grabTarget(LivingEntity entity) {
        if (this.grabbed || this.grabbedTarget != null) {
            return false;
        }
        this.returning = true;
        this.grabbed = true;
        this.grabbedTarget = entity;
        this.glove.teleport((Position)this.grabbedTarget.eyeLocation().subtract(0.0, this.grabbedTarget.height() / 2.0, 0.0));
        this.grabbedTarget.setProperty(EntityProperties.FALL_DISTANCE, 0.0);
        if (this.isMetal) {
            this.removalPolicy = Policies.builder().add(Policies.UNDER_WATER).add(Policies.UNDER_LAVA).add(SwappedSlotsRemovalPolicy.of(this.description())).add(OutOfRangeRemovalPolicy.of(this.userConfig.range + 5.0, () -> this.location)).add(ExpireRemovalPolicy.of(this.userConfig.grabDuration)).build();
        }
        return true;
    }

    private boolean launchEarthGlove() {
        Side side = this.user.store().toggle(KEY, Side.RIGHT);
        Vector3d gloveSpawnLocation = this.user.handSide(side == Side.RIGHT);
        Vector3d target = this.user.rayTrace(this.userConfig.range).cast(this.user.world()).entityCenterOrPosition();
        this.glove = this.buildGlove((Vector3d)gloveSpawnLocation.subtract(0.0, 0.2, 0.0));
        if (this.isMetal) {
            SoundEffect.METAL.play(this.user.world(), gloveSpawnLocation);
        } else {
            Sound.BLOCK_STONE_BREAK.asEffect(1.0f, 1.5f).play(this.user.world(), gloveSpawnLocation);
        }
        double factor = this.isMetal ? BendingProperties.instance().metalModifier() : 1.0;
        Vector3d velocity = (Vector3d)((Vector3d)target.subtract(gloveSpawnLocation)).normalize().multiply(1.2 * factor);
        this.updateGloveVelocity(velocity);
        this.location = this.glove.location();
        return true;
    }

    private Entity buildGlove(Vector3d spawnLocation) {
        Inventory inventory = this.user.inventory();
        if (inventory instanceof PlayerInventory) {
            PlayerInventory inv = (PlayerInventory)inventory;
            this.isMetal = this.user.hasPermission(FeaturePermissions.METAL) && inv.remove(Item.IRON_INGOT);
        }
        ItemSnapshot item = Platform.instance().factory().itemBuilder(this.isMetal ? Item.IRON_INGOT : Item.STONE).build();
        Entity entity = this.user.world().dropItem(spawnLocation, item, false);
        entity.setProperty(EntityProperties.INVULNERABLE, true);
        entity.setProperty(EntityProperties.GRAVITY, this.isMetal);
        entity.add(GLOVE_KEY, this);
        return entity;
    }

    private void updateGloveVelocity(Vector3d velocity) {
        this.glove.applyVelocity(this, velocity);
        this.lastVelocity = this.glove.velocity();
    }

    @Override
    public void onDestroy() {
        if (this.glove != null) {
            if (this.isMetal) {
                this.glove.setProperty(EntityProperties.ALLOW_PICKUP, true);
            } else {
                this.glove.remove();
            }
        }
    }

    @Override
    public Collection<Collider> colliders() {
        return this.glove == null || this.returning ? List.of() : List.of(Sphere.of(this.location, 0.8));
    }

    public void shatterGlove() {
        if (!this.glove.valid()) {
            return;
        }
        if (!this.isMetal) {
            BlockType.STONE.asParticle(this.location).count(6).offset(0.1).spawn(this.user.world());
        }
        this.onDestroy();
    }

    private static void tryDestroy(User user) {
        Vector3d eyeLoc = user.eyeLocation();
        Vector3d dir = user.direction();
        CollisionUtil.handle(user, Sphere.of(user.eyeLocation(), 8.0), entity -> {
            EarthGlove ability;
            if (entity.type() == EntityType.ITEM && ((Vector3d)entity.location().subtract(eyeLoc)).angle(dir) < 1.0471975511965976 && (ability = (EarthGlove)entity.get(GLOVE_KEY).orElse(null)) != null && !user.equals(ability.user())) {
                ability.shatterGlove();
            }
            return true;
        }, false, false);
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 750L;
        @Modifiable(value=Attribute.RANGE)
        private double range = 16.0;
        @Comment(value="The maximum amount of milliseconds that the target will be controlled when grabbed by metal clips")
        @Modifiable(value=Attribute.DURATION)
        private long grabDuration = 4000L;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 1.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "earthglove");
        }
    }

    private static enum Side {
        RIGHT,
        LEFT;

    }
}

