/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.earth;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.Pillar;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.Direction;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.BendingEffect;
import me.moros.bending.api.util.material.EarthMaterials;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import org.jspecify.annotations.Nullable;

public class Catapult
extends AbilityInstance {
    private static final double ANGLE = Math.toRadians(60.0);
    private Config userConfig;
    private BlockState data;
    private Vector3d push;
    private Pillar pillar;
    private boolean launched;
    private long startTime;

    public Catapult(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        if (this.prepareLaunch(method == Activation.SNEAK)) {
            user.addCooldown(this.description(), this.userConfig.cooldown);
            return true;
        }
        return false;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        this.launch();
        if (System.currentTimeMillis() > this.startTime + 100L) {
            return this.pillar == null ? Updatable.UpdateResult.REMOVE : this.pillar.update();
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    private @Nullable Block getBase() {
        Vector3d center = this.user.location();
        AABB entityBounds = this.user.bounds().grow(Vector3d.of(0.0, 0.2, 0.0));
        AABB floorBounds = AABB.of(Vector3d.of(-1.0, -0.5, -1.0), Vector3d.of(1.0, 0.0, 1.0)).at(center);
        return this.user.world().nearbyBlocks(floorBounds, b -> entityBounds.intersects(b.bounds())).stream().filter(this::isValidBlock).min(Comparator.comparingDouble(b -> b.center().distanceSq(center))).orElse(null);
    }

    private boolean isValidBlock(Block block) {
        if (block.type().isLiquid() || !TempBlock.isBendable(block) || !this.user.canBuild(block)) {
            return false;
        }
        return EarthMaterials.isEarthbendable(this.user, block);
    }

    private boolean prepareLaunch(boolean sneak) {
        double basePower;
        Vector3d direction = this.user.direction();
        double angle = Vector3d.PLUS_J.angle(direction);
        int length = 0;
        Block base = this.getBase();
        double d = basePower = sneak ? this.userConfig.sneakPower : this.userConfig.clickPower;
        if (base != null) {
            length = this.getLength(base.offset(Direction.UP).toVector3d(), Vector3d.MINUS_J);
            if (angle > ANGLE) {
                direction = Vector3d.PLUS_J;
            }
            this.pillar = Pillar.builder(this.user, base, EarthPillar::new).predicate(b -> !b.type().isLiquid() && EarthMaterials.isEarthbendable(this.user, b)).build(3, 1).orElse(null);
        } else if (angle >= ANGLE && angle <= 2.0 * ANGLE) {
            length = this.getLength(this.user.location(), direction.negate());
            basePower *= this.userConfig.horizontalFactor;
        }
        double factor = (double)length / (double)this.userConfig.length;
        double power = basePower * factor;
        this.push = (Vector3d)direction.multiply(power);
        return power > 0.0;
    }

    private void launch() {
        if (this.launched) {
            return;
        }
        this.launched = true;
        this.startTime = System.currentTimeMillis();
        Vector3d origin = this.user.location().add(0.0, 0.5, 0.0);
        SoundEffect.EARTH.play(this.user.world(), origin);
        this.data.asParticle(origin).count(16).offset(0.4).spawn(this.user.world());
        CollisionUtil.handle(this.user, Sphere.of(origin, 1.5), entity -> {
            BendingEffect.FIRE_TICK.reset(entity);
            entity.applyVelocity(this, this.push);
            return true;
        }, true, true);
    }

    private int getLength(Vector3d origin, Vector3d direction) {
        HashSet<Block> checked = new HashSet<Block>();
        for (double i = 0.5; i <= (double)this.userConfig.length; i += 0.5) {
            Block block = this.user.world().blockAt((Position)origin.add((Position)direction.multiply(i)));
            if (checked.add(block) && !this.isValidBlock(block)) {
                return FastMath.ceil(i) - 1;
            }
            if (this.data != null) continue;
            this.data = block.state();
        }
        return this.userConfig.length;
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 3000L;
        @Modifiable(value=Attribute.STRENGTH)
        private double sneakPower = 2.65;
        @Modifiable(value=Attribute.STRENGTH)
        private double clickPower = 1.8;
        @Modifiable(value=Attribute.STRENGTH)
        private double horizontalFactor = 1.4;
        private int length = 7;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "earth", "catapult");
        }
    }

    private static final class EarthPillar
    extends Pillar {
        private EarthPillar(Pillar.Builder<EarthPillar> builder) {
            super(builder);
        }

        @Override
        public void playSound(Block block) {
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            return true;
        }
    }
}

