/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.air.sequence;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.AABB;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Disk;
import me.moros.bending.api.collision.geometry.OBB;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.registry.Registries;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.ExpiringSet;
import me.moros.bending.common.ability.air.AirScooter;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;

public class AirWheel
extends AbilityInstance {
    private static final AABB BOUNDS = AABB.of(Vector3d.of(-0.4, -2.0, -2.0), Vector3d.of(0.4, 2.0, 2.0));
    private static AbilityDescription scooterDesc;
    private Config userConfig;
    private final ExpiringSet<UUID> affectedEntities = new ExpiringSet(500L);
    private AirScooter scooter;
    private Collider collider;
    private Vector3d center;
    private long nextRenderTime;

    public AirWheel(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, AirWheel.class)) {
            return false;
        }
        if (scooterDesc == null) {
            scooterDesc = Objects.requireNonNull(Registries.ABILITIES.fromString("AirScooter"));
        }
        this.scooter = new AirScooter(scooterDesc, false);
        if (user.onCooldown(scooterDesc) || !this.scooter.activate(user, Activation.ATTACK)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        this.center = user.location().add(0.0, 0.8, 0.0);
        this.nextRenderTime = 0L;
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        long time = System.currentTimeMillis();
        this.center = (Vector3d)this.user.location().add(0.0, 0.8, 0.0).add((Position)((Vector3d)this.user.direction().withY(0.0)).multiply(1.2));
        this.collider = Disk.of(Sphere.of(2.0), OBB.of(BOUNDS, Vector3d.PLUS_J, Math.toRadians(this.user.yaw()))).at(this.center);
        if (time >= this.nextRenderTime) {
            this.render();
            this.nextRenderTime = time + 100L;
        }
        Block base = this.user.world().blockAt((Position)this.center.subtract(0.0, 1.6, 0.0));
        WorldUtil.tryCoolLava(this.user, base);
        WorldUtil.tryExtinguishFire(this.user, base);
        CollisionUtil.handle(this.user, this.collider, this::onEntityHit);
        return this.scooter.update();
    }

    private boolean onEntityHit(Entity entity) {
        if (this.affectedEntities.add(entity.uuid())) {
            entity.damage(this.userConfig.damage, this.user, this.description());
            return true;
        }
        return false;
    }

    @Override
    public void onDestroy() {
        this.scooter.onDestroy();
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
    }

    private void render() {
        Vector3d rotateAxis = Vector3d.PLUS_J.cross((Position)this.user.direction().withY(0.0));
        VectorUtil.circle((Vector3d)this.user.direction().multiply(1.8), rotateAxis, 40).forEach(v -> ParticleBuilder.air(this.center.add((Position)v)).spawn(this.user.world()));
    }

    public Vector3d center() {
        return this.center;
    }

    @Override
    public Collection<Collider> colliders() {
        return List.of(this.collider);
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 8000L;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 1.0;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "air", "sequences", "airwheel");
        }
    }
}

