/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.air.passive;

import java.util.List;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.config.attribute.ModifierOperation;
import me.moros.bending.api.platform.entity.AttributeType;
import me.moros.bending.api.platform.entity.EntityProperties;
import me.moros.bending.api.user.User;
import org.spongepowered.configurate.objectmapping.meta.Comment;

public class GracefulDescent
extends AbilityInstance {
    private Config userConfig;
    private boolean modifiedFall = false;

    public GracefulDescent(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (!this.modifiedFall) {
            this.user.propertyValue(EntityProperties.ATTRIBUTES).addModifier(AttributeType.SAFE_FALL_DISTANCE, this.description().key(), ModifierOperation.ADDITIVE, this.userConfig.safeFallDistanceBonus);
            this.modifiedFall = true;
        }
        return Updatable.UpdateResult.CONTINUE;
    }

    @Override
    public void onDestroy() {
        this.user.propertyValue(EntityProperties.ATTRIBUTES).removeModifier(AttributeType.SAFE_FALL_DISTANCE, this.description().key());
        this.modifiedFall = false;
    }

    private boolean isGraceful() {
        if (!this.user.canBend(this.description())) {
            return false;
        }
        return this.user.propertyValue(EntityProperties.ATTRIBUTES).value(AttributeType.ARMOR).orElse(0.0) < (double)this.userConfig.heavyArmorThreshold;
    }

    public static boolean isGraceful(User user) {
        return user.game().abilityManager(user.worldKey()).firstInstance(user, GracefulDescent.class).map(GracefulDescent::isGraceful).orElse(false);
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.HEIGHT)
        private double safeFallDistanceBonus = 8.0;
        @Comment(value="Armor points greater than or equal to this value are considered heavy and the passive will no longer function.")
        @Modifiable(value=Attribute.STRENGTH)
        private int heavyArmorThreshold = 8;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "air", "passives", "gracefuldescent");
        }
    }
}

