/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.air;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import me.moros.bending.api.ability.Ability;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.element.Element;
import me.moros.bending.api.collision.Collision;
import me.moros.bending.api.collision.CollisionUtil;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Sphere;
import me.moros.bending.api.config.BendingProperties;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.temporal.TempBlock;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.functional.SwappedSlotsRemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.bending.common.ability.water.FrostBreath;
import me.moros.math.FastMath;
import me.moros.math.Position;
import me.moros.math.Vector3d;

public class AirShield
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Vector3d center;
    private long currentPoint = 0L;
    private long startTime;

    public AirShield(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        this.removalPolicy = Policies.builder().add(SwappedSlotsRemovalPolicy.of(this.description())).add(Policies.NOT_SNEAKING).add(ExpireRemovalPolicy.of(this.userConfig.duration)).build();
        this.startTime = System.currentTimeMillis();
        this.center = user.center();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description()) || !this.user.canBuild()) {
            return Updatable.UpdateResult.REMOVE;
        }
        ++this.currentPoint;
        this.center = this.user.center();
        double spacing = this.userConfig.radius / 4.0;
        for (int i = 1; i < 8; ++i) {
            double y = (double)i * spacing - this.userConfig.radius;
            double factor = 1.0 - y * y / (this.userConfig.radius * this.userConfig.radius);
            if (factor <= 0.2) continue;
            double x = this.userConfig.radius * factor * Math.cos((long)i * this.currentPoint);
            double z = this.userConfig.radius * factor * Math.sin((long)i * this.currentPoint);
            Vector3d loc = this.center.add(x, y, z);
            ParticleBuilder.air(loc).count(5).offset(0.2).spawn(this.user.world());
            if (ThreadLocalRandom.current().nextInt(12) != 0) continue;
            SoundEffect.AIR.play(this.user.world(), loc);
        }
        for (Block b : this.user.world().nearbyBlocks(this.center, this.userConfig.radius, MaterialUtil::isFire)) {
            WorldUtil.tryCoolLava(this.user, b);
            WorldUtil.tryExtinguishFire(this.user, b);
        }
        CollisionUtil.handle(this.user, Sphere.of(this.center, this.userConfig.radius), this::onEntityHit, false);
        return Updatable.UpdateResult.CONTINUE;
    }

    private boolean onEntityHit(Entity entity) {
        Vector3d toEntity = (Vector3d)entity.location().subtract(this.center);
        Vector3d normal = ((Vector3d)toEntity.withY(0.0)).normalize();
        double strength = (this.userConfig.radius - toEntity.length()) / this.userConfig.radius * this.userConfig.maxPush;
        strength = Math.clamp(strength, 0.0, 1.0);
        entity.applyVelocity(this, (Vector3d)entity.velocity().add((Position)normal.multiply(strength)));
        return false;
    }

    @Override
    public void onDestroy() {
        double factor = this.userConfig.duration == 0L ? 1.0 : (double)System.currentTimeMillis() - (double)this.startTime / (double)this.userConfig.duration;
        long cooldown = Math.min(1000L, (long)(factor * (double)this.userConfig.cooldown));
        this.user.addCooldown(this.description(), cooldown);
    }

    @Override
    public Collection<Collider> colliders() {
        return List.of(Sphere.of(this.center, this.userConfig.radius));
    }

    private void forEachSurfaceBlock(Consumer<Block> consumer) {
        int r = FastMath.ceil(this.userConfig.radius);
        double rMinSq = (this.userConfig.radius - 1.0) * (this.userConfig.radius - 1.0);
        double rMaxSq = this.userConfig.radius * this.userConfig.radius;
        for (double x = this.center.x() - (double)r; x <= this.center.x() + (double)r; x += 1.0) {
            for (double y = this.center.y() - (double)r; y <= this.center.y() + (double)r; y += 1.0) {
                for (double z = this.center.z() - (double)r; z <= this.center.z() + (double)r; z += 1.0) {
                    Vector3d loc = Vector3d.of(x, y, z);
                    double distSq = this.center.distanceSq(loc);
                    if (distSq < rMinSq || distSq > rMaxSq) continue;
                    consumer.accept(this.user.world().blockAt(loc));
                }
            }
        }
    }

    @Override
    public void onCollision(Collision collision) {
        Ability collidedAbility = collision.collidedAbility();
        if (collidedAbility instanceof FrostBreath) {
            this.forEachSurfaceBlock(block -> {
                if (MaterialUtil.isTransparentOrWater(block) && this.user.canBuild((Block)block)) {
                    WorldUtil.tryBreakPlant(block);
                    if (MaterialUtil.isAir(block) || MaterialUtil.isWater(block)) {
                        TempBlock.ice().duration(BendingProperties.instance().iceRevertTime(1500L)).build((Block)block);
                    }
                }
            });
        } else if (collidedAbility.description().elements().contains((Object)Element.FIRE)) {
            double r = this.userConfig.radius;
            Vector3d pos = (Vector3d)this.center.add((Position)((Vector3d)collision.colliderOther().position().subtract(this.center)).normalize().multiply(r));
            ParticleBuilder.fire(collidedAbility.user(), pos).count(20).offset(0.1).extra(0.05).spawn(this.user.world());
            SoundEffect.FIRE_EXTINGUISH.play(this.user.world(), pos);
        }
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 4000L;
        @Modifiable(value=Attribute.DURATION)
        private long duration = 10000L;
        @Modifiable(value=Attribute.RADIUS)
        private double radius = 4.0;
        @Modifiable(value=Attribute.STRENGTH)
        private double maxPush = 2.6;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "air", "airshield");
        }
    }
}

