/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.air;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.AbstractRide;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.BlockState;
import me.moros.bending.api.platform.particle.ParticleBuilder;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.ExpireRemovalPolicy;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.common.ability.air.sequence.AirWheel;
import me.moros.math.Vector3d;

public class AirScooter
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private Scooter scooter;
    private final boolean canRender;

    public AirScooter(AbilityDescription desc) {
        super(desc);
        this.canRender = true;
    }

    public AirScooter(AbilityDescription desc, boolean canRender) {
        super(desc);
        this.canRender = canRender;
    }

    @Override
    public boolean activate(User user, Activation method) {
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, AirScooter.class)) {
            return false;
        }
        if (user.game().abilityManager(user.worldKey()).hasAbility(user, AirWheel.class)) {
            return false;
        }
        this.user = user;
        this.loadConfig();
        double dist = user.distanceAboveGround(3.5);
        if (dist < 0.5 || dist > 3.25) {
            return false;
        }
        this.removalPolicy = Policies.builder().add(Policies.SNEAKING).add(Policies.UNDER_WATER).add(Policies.UNDER_LAVA).add(ExpireRemovalPolicy.of(this.userConfig.duration)).build();
        if (this.removalPolicy.test(user, this.description())) {
            return false;
        }
        this.scooter = new Scooter();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        if (!this.user.canBuild()) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.scooter.update();
    }

    @Override
    public void onDestroy() {
        this.scooter.onDestroy();
        this.user.addCooldown(this.description(), this.userConfig.cooldown);
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.SPEED)
        private double speed = 0.7;
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 2000L;
        @Modifiable(value=Attribute.DURATION)
        private long duration = 15000L;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "air", "airscooter");
        }
    }

    private final class Scooter
    extends AbstractRide {
        private static final double RADIUS = 0.8;
        private double verticalPosition;

        private Scooter() {
            super(AirScooter.this.user, AirScooter.this.userConfig.speed, 2.5);
            this.verticalPosition = 0.0;
        }

        @Override
        public void render(BlockState data) {
            if (!AirScooter.this.canRender) {
                return;
            }
            this.verticalPosition += 0.7853981633974483;
            Vector3d location = AirScooter.this.user.location();
            for (double theta = 0.0; theta < Math.PI * 4; theta += 0.6283185307179586) {
                double sin = Math.sin(this.verticalPosition);
                double x = 0.8 * Math.cos(theta) * sin;
                double y = 0.8 * Math.cos(this.verticalPosition);
                double z = 0.8 * Math.sin(theta) * sin;
                ParticleBuilder.air(location.add(x, y - 0.25, z)).spawn(AirScooter.this.user.world());
            }
        }

        @Override
        public void postRender() {
            if (ThreadLocalRandom.current().nextInt(4) == 0) {
                SoundEffect.AIR.play(AirScooter.this.user.world(), AirScooter.this.user.location());
            }
        }

        @Override
        protected void affect(Vector3d velocity) {
            AirScooter.this.user.applyVelocity(AirScooter.this, velocity);
        }
    }
}

