/*
 * Decompiled with CFR 0.152.
 */
package me.moros.bending.common.ability.air;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.moros.bending.api.ability.AbilityDescription;
import me.moros.bending.api.ability.AbilityInstance;
import me.moros.bending.api.ability.Activation;
import me.moros.bending.api.ability.Updatable;
import me.moros.bending.api.ability.common.basic.ParticleStream;
import me.moros.bending.api.collision.geometry.Collider;
import me.moros.bending.api.collision.geometry.Ray;
import me.moros.bending.api.config.Configurable;
import me.moros.bending.api.config.attribute.Attribute;
import me.moros.bending.api.config.attribute.Modifiable;
import me.moros.bending.api.platform.block.Block;
import me.moros.bending.api.platform.entity.Entity;
import me.moros.bending.api.platform.particle.Particle;
import me.moros.bending.api.platform.sound.Sound;
import me.moros.bending.api.platform.sound.SoundEffect;
import me.moros.bending.api.platform.world.WorldUtil;
import me.moros.bending.api.user.User;
import me.moros.bending.api.util.functional.Policies;
import me.moros.bending.api.util.functional.RemovalPolicy;
import me.moros.bending.api.util.material.MaterialUtil;
import me.moros.math.Position;
import me.moros.math.Vector3d;
import me.moros.math.VectorUtil;

public class AirPunch
extends AbilityInstance {
    private Config userConfig;
    private RemovalPolicy removalPolicy;
    private AirStream stream;

    public AirPunch(AbilityDescription desc) {
        super(desc);
    }

    @Override
    public boolean activate(User user, Activation method) {
        this.user = user;
        this.loadConfig();
        Vector3d origin = user.mainHandSide();
        Vector3d lookingDir = (Vector3d)user.direction().multiply(this.userConfig.range);
        if (user.world().blockAt(origin).type().isLiquid()) {
            return false;
        }
        user.addCooldown(this.description(), this.userConfig.cooldown);
        double length = ((Vector3d)user.velocity().subtract(user.direction())).length();
        double factor = length == 0.0 ? 1.0 : Math.clamp(1.0 / length, 0.5, 1.5);
        Sound.ENTITY_BREEZE_SHOOT.asEffect(1.0f, (float)factor).play(user.world(), origin);
        this.stream = new AirStream(Ray.of(origin, lookingDir), 1.2, factor);
        this.removalPolicy = Policies.defaults();
        return true;
    }

    @Override
    public void loadConfig() {
        this.userConfig = this.user.game().configProcessor().calculate(this, Config.class);
    }

    @Override
    public Updatable.UpdateResult update() {
        if (this.removalPolicy.test(this.user, this.description())) {
            return Updatable.UpdateResult.REMOVE;
        }
        return this.stream.update();
    }

    @Override
    public Collection<Collider> colliders() {
        return List.of(this.stream.collider());
    }

    private static final class Config
    implements Configurable {
        @Modifiable(value=Attribute.COOLDOWN)
        private long cooldown = 2500L;
        @Modifiable(value=Attribute.DAMAGE)
        private double damage = 3.0;
        @Modifiable(value=Attribute.RANGE)
        private double range = 18.0;
        @Modifiable(value=Attribute.SPEED)
        private double speed = 0.8;

        private Config() {
        }

        @Override
        public List<String> path() {
            return List.of("abilities", "air", "airpunch");
        }
    }

    private class AirStream
    extends ParticleStream {
        private final double factor;

        public AirStream(Ray ray, double collisionRadius, double factor) {
            super(AirPunch.this.user, ray, AirPunch.this.userConfig.speed * factor, collisionRadius);
            this.factor = factor;
            this.canCollide = b -> b.isLiquid() || MaterialUtil.isFire(b);
        }

        @Override
        public void render(Vector3d location) {
            VectorUtil.circle((Vector3d)Vector3d.ONE.multiply(0.75), AirPunch.this.user.direction(), 10).forEach(v -> Particle.CLOUD.builder((Position)location.add((Position)v)).count(0).offset((Position)v).extra(-0.04).spawn(AirPunch.this.user.world()));
        }

        @Override
        public void postRender(Vector3d location) {
            if (ThreadLocalRandom.current().nextInt(6) == 0) {
                SoundEffect.AIR_FAST.play(AirPunch.this.user.world(), location);
            }
        }

        @Override
        public boolean onEntityHit(Entity entity) {
            entity.damage(AirPunch.this.userConfig.damage * this.factor, AirPunch.this.user, AirPunch.this.description());
            Vector3d velocity = (Vector3d)((Vector3d)entity.center().subtract(this.ray.position())).normalize().multiply(this.factor);
            entity.applyVelocity(AirPunch.this, velocity);
            return true;
        }

        @Override
        public boolean onBlockHit(Block block) {
            if (WorldUtil.tryExtinguishFire(AirPunch.this.user, block)) {
                return false;
            }
            WorldUtil.tryCoolLava(AirPunch.this.user, block);
            return true;
        }
    }
}

